/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ClobDBAccess;
import oracle.sql.DatumWithConnection;

public class CLOB
extends DatumWithConnection
implements Clob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    ClobDBAccess dbaccess;
    private int dbChunkSize;
    private short csform;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:33_PDT_2005";

    protected CLOB() {
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (byArray != null) {
            this.csform = (byArray[5] & 0xC0) == 64 ? (short)2 : (short)1;
        }
        DatumWithConnection.assertNotNull(oracleConnection);
        this.setPhysicalConnectionOf(oracleConnection);
        this.dbaccess = ((OracleConnection)oracleConnection).createClobDBAccess();
        this.dbChunkSize = -1;
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, short s2) throws SQLException {
        this(oracleConnection, byArray);
        this.csform = s2;
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public Reader characterStreamValue() throws SQLException {
        return this.getCharacterStream();
    }

    public void close() throws SQLException {
        this.getDBAccess().close(this);
    }

    public static CLOB createTemporary(Connection connection, boolean bl2, int n2) throws SQLException {
        return CLOB.createTemporary(connection, bl2, n2, (short)1);
    }

    public static CLOB createTemporary(Connection connection, boolean bl2, int n2, short s2) throws SQLException {
        int n3 = n2;
        if (n2 == 1) {
            n3 = 10;
        }
        if (n2 == 2) {
            n3 = 12;
        }
        if (connection == null || n3 != 10 && n3 != 12) {
            DatabaseError.throwSqlException(68);
        }
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        CLOB cLOB = CLOB.getDBAccess(oracleConnection).createTemporaryClob(oracleConnection, bl2, n3, s2);
        cLOB.csform = s2;
        return cLOB;
    }

    public static CLOB empty_lob() throws SQLException {
        return CLOB.getEmptyCLOB();
    }

    public void freeTemporary() throws SQLException {
        this.getDBAccess().freeTemporary(this);
    }

    public static void freeTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return;
        }
        cLOB.freeTemporary();
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.setAsciiStream(0L);
    }

    public OutputStream getAsciiOutputStream(long l2) throws SQLException {
        return this.setAsciiStream(l2);
    }

    public InputStream getAsciiStream() throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public InputStream getAsciiStream(long l2) throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l2);
    }

    public int getBufferSize() throws SQLException {
        int n2 = this.getChunkSize();
        int n3 = 0;
        n3 = n2 >= 32768 || n2 <= 0 ? 32768 : 32768 / n2 * n2;
        return n3;
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return this.setCharacterStream(0L);
    }

    public Writer getCharacterOutputStream(long l2) throws SQLException {
        return this.setCharacterStream(l2);
    }

    public Reader getCharacterStream() throws SQLException {
        return this.getDBAccess().newReader(this, this.getBufferSize(), 0L);
    }

    public Reader getCharacterStream(long l2) throws SQLException {
        return this.getDBAccess().newReader(this, this.getBufferSize(), l2);
    }

    public int getChars(long l2, int n2, char[] cArray) throws SQLException {
        return this.getDBAccess().getChars(this, l2, n2, cArray);
    }

    public int getChunkSize() throws SQLException {
        if (this.dbChunkSize <= 0) {
            this.dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.dbChunkSize;
    }

    public ClobDBAccess getDBAccess() throws SQLException {
        if (this.dbaccess == null) {
            if (this.isEmptyLob()) {
                DatabaseError.throwSqlException(98);
            }
            this.dbaccess = this.getInternalConnection().createClobDBAccess();
        }
        if (this.getPhysicalConnection().isClosed()) {
            DatabaseError.throwSqlException(8);
        }
        return this.dbaccess;
    }

    public static ClobDBAccess getDBAccess(Connection connection) throws SQLException {
        return ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().createClobDBAccess();
    }

    public static CLOB getEmptyCLOB() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        CLOB cLOB = new CLOB();
        cLOB.setShareBytes(byArray);
        return cLOB;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public String getSubString(long l2, int n2) throws SQLException {
        char[] cArray;
        int n3;
        if (n2 < 0 || l2 < 1L) {
            DatabaseError.throwSqlException(68, "getSubString");
        }
        String string = null;
        string = n2 == 0 ? new String() : ((n3 = this.getChars(l2, n2, cArray = new char[n2])) > 0 ? new String(cArray, 0, n3) : new String());
        return string;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public boolean isEmptyLob() throws SQLException {
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    public boolean isNCLOB() {
        boolean bl2 = this.csform == 2;
        return bl2;
    }

    public boolean isOpen() throws SQLException {
        return this.getDBAccess().isOpen(this);
    }

    public boolean isTemporary() throws SQLException {
        return this.getDBAccess().isTemporary(this);
    }

    public static boolean isTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return false;
        }
        return cLOB.isTemporary();
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public Object makeJdbcArray(int n2) {
        return new CLOB[n2];
    }

    public void open(int n2) throws SQLException {
        this.getDBAccess().open(this, n2);
    }

    public long position(String string, long l2) throws SQLException {
        return this.getDBAccess().position(this, string, l2);
    }

    public long position(Clob clob, long l2) throws SQLException {
        return this.getDBAccess().position(this, (CLOB)clob, l2);
    }

    public int putChars(long l2, char[] cArray) throws SQLException {
        int n2 = this.getDBAccess().putChars(this, l2, cArray, 0, cArray != null ? cArray.length : 0);
        return n2;
    }

    public int putChars(long l2, char[] cArray, int n2) throws SQLException {
        return this.getDBAccess().putChars(this, l2, cArray, 0, n2);
    }

    public int putChars(long l2, char[] cArray, int n2, int n3) throws SQLException {
        return this.getDBAccess().putChars(this, l2, cArray, n2, n3);
    }

    public int putString(long l2, String string) throws SQLException {
        return this.setString(l2, string);
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l2);
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        return this.getDBAccess().newWriter(this, this.getBufferSize(), l2);
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public int setString(long l2, String string) throws SQLException {
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "setString()");
        }
        int n2 = 0;
        if (string != null && string.length() != 0) {
            n2 = this.putChars(l2, string.toCharArray());
        }
        return n2;
    }

    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "setString()");
        }
        if (n2 < 0) {
            DatabaseError.throwSqlException(68, "setString()");
        }
        if (n2 + n3 > string.length()) {
            DatabaseError.throwSqlException(68, "setString()");
        }
        int n4 = 0;
        if (string != null && string.length() != 0) {
            n4 = this.putChars(l2, string.toCharArray(), n2, n3);
        }
        return n4;
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public void trim(long l2) throws SQLException {
        this.truncate(l2);
    }

    public void truncate(long l2) throws SQLException {
        if (l2 < 0L) {
            DatabaseError.throwSqlException(68);
        }
        this.getDBAccess().trim(this, l2);
    }
}

