/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetByte
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetByte(int n2) {
        super(n2);
        this.rep = 1;
    }

    static byte[] charsToBytes(char[] cArray, byte by) throws SQLException {
        byte[] byArray = new byte[cArray.length];
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] > '\u00ff') {
                byArray[n2] = by;
                if (by == 0) {
                    CharacterSet.failCharacterConversion(CharacterSet.make(31));
                }
            } else {
                byArray[n2] = (byte)cArray[n2];
            }
            ++n2;
        }
        return byArray;
    }

    public byte[] convert(String string) throws SQLException {
        int n2 = string.length();
        char[] cArray = new char[string.length()];
        string.getChars(0, n2, cArray, 0);
        return CharacterSetByte.charsToBytes(cArray, (byte)0);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 1) {
            byArray2 = CharacterSet.useOrCopy(byArray, n2, n3);
        } else if (characterSet.rep == 2) {
            char[] cArray = CharacterSet.UTFToJavaChar(byArray, n2, n3);
            byArray2 = CharacterSetByte.charsToBytes(cArray, (byte)0);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            char[] cArray = string.toCharArray();
            byArray2 = CharacterSetByte.charsToBytes(cArray, (byte)0);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        int n2 = string.length();
        char[] cArray = new char[string.length()];
        string.getChars(0, n2, cArray, 0);
        try {
            return CharacterSetByte.charsToBytes(cArray, (byte)63);
        }
        catch (SQLException sQLException) {
            return new byte[0];
        }
    }

    int decode(CharacterWalker characterWalker) {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        return n2;
    }

    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        CharacterSet.need(characterBuffer, 1);
        if (n2 < 256) {
            characterBuffer.bytes[characterBuffer.next] = (byte)n2;
            ++characterBuffer.next;
        }
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        return characterSet.rep <= 1024;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.rep != 1;
    }

    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        return this.toString(byArray, n2, n3, '\u0000');
    }

    private String toString(byte[] byArray, int n2, int n3, char c2) throws SQLException {
        try {
            return new String(byArray, n2, n3, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("ascii not supported");
        }
    }

    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            return this.toString(byArray, n2, n3, '?');
        }
        catch (SQLException sQLException) {
            throw new Error("CharacterSetByte.toString");
        }
    }
}

