/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverters;

class CharacterSetLCFixed
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterLCFixed";
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;

    CharacterSetLCFixed(int n2, CharacterConverters characterConverters) {
        super(n2, characterConverters);
        this.m_leadingCodes = characterConverters.getLeadingCodes();
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        if (characterWalker.bytes.length - characterWalker.next < 4) {
            throw new SQLException("destination too small");
        }
        int n2 = characterWalker.bytes[characterWalker.next] << 8 | characterWalker.bytes[characterWalker.next + 1];
        int n3 = 0;
        while (n3 < this.m_leadingCodes.length) {
            if (n2 == this.m_leadingCodes[n3]) {
                int n4 = 0;
                int n5 = 0;
                while (n5 < 4) {
                    n4 = n4 << 8 | characterWalker.bytes[characterWalker.next++];
                    ++n5;
                }
                return n4;
            }
            ++n3;
        }
        throw new SQLException("Leading code invalid");
    }

    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = n2 >> 16;
        int n4 = 0;
        while (n4 < this.m_leadingCodes.length) {
            if (n3 == this.m_leadingCodes[n4]) {
                CharacterSet.need(characterBuffer, 4);
                int n5 = 3;
                while (n5 >= 0) {
                    characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> 8 * n5 & 0xFF);
                    --n5;
                }
                return;
            }
            ++n4;
        }
        throw new SQLException("Leading code invalid");
    }

    static CharacterSetLCFixed getInstance(int n2, CharacterConverters characterConverters) {
        if (characterConverters.getGroupId() == 3) {
            return new CharacterSetLCFixed(n2, characterConverters);
        }
        return null;
    }
}

