/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetUTF
extends CharacterSet
implements CharacterRepConstants {
    private static int[] m_byteLen;

    static {
        int[] nArray = new int[16];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 3;
        m_byteLen = nArray;
    }

    CharacterSetUTF(int n2) {
        super(n2);
        this.rep = 2;
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSet.stringToUTF(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 2) {
            byArray2 = CharacterSet.useOrCopy(byArray, n2, n3);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            byArray2 = CharacterSet.stringToUTF(string);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSet.stringToUTF(string);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        byte by;
        int n2;
        byte[] byArray = characterWalker.bytes;
        int n3 = characterWalker.next;
        int n4 = characterWalker.end;
        if (n3 >= n4) {
            CharacterSet.failUTFConversion();
        }
        if ((n2 = CharacterSetUTF.getUTFByteLength(by = byArray[n3])) == 0 || n3 + (n2 - 1) >= n4) {
            CharacterSet.failUTFConversion();
        }
        if (n2 == 3 && CharacterSetUTF.isHiSurrogate(by, byArray[n3 + 1]) && n3 + 5 < n4) {
            n2 = 6;
        }
        try {
            char[] cArray = new char[2];
            int[] nArray = new int[]{n2};
            int n5 = CharacterSet.convertUTFBytesToJavaChars(byArray, n3, cArray, 0, nArray, false);
            characterWalker.next += n2;
            if (n5 == 1) {
                return cArray[0];
            }
            return cArray[0] << 16 | cArray[1];
        }
        catch (SQLException sQLException) {
            CharacterSet.failUTFConversion();
            return 0;
        }
    }

    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3;
        if ((n2 & 0xFFFF0000) != 0) {
            CharacterSet.need(characterBuffer, 6);
            char[] cArray = new char[]{(char)(n2 >>> 16), (char)n2};
            n3 = CharacterSet.convertJavaCharsToUTFBytes(cArray, 0, characterBuffer.bytes, characterBuffer.next, 2);
        } else {
            CharacterSet.need(characterBuffer, 3);
            char[] cArray = new char[]{(char)n2};
            n3 = CharacterSet.convertJavaCharsToUTFBytes(cArray, 0, characterBuffer.bytes, characterBuffer.next, 1);
        }
        characterBuffer.next += n3;
    }

    public int encodedByteLength(String string) {
        return CharacterSet.stringUTFLength(string);
    }

    public int encodedByteLength(char[] cArray) {
        return CharacterSet.charArrayUTF8Length(cArray);
    }

    private static int getUTFByteLength(byte by) {
        return m_byteLen[by >>> 4 & 0xF];
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl2 = characterSet.rep <= 1024;
        return bl2;
    }

    private static boolean isHiSurrogate(byte by, byte by2) {
        return by == -19 && by2 >= -96;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.isUnicode() ^ true;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int[] nArray = new int[]{n3};
            int n4 = CharacterSet.convertUTFBytesToJavaChars(byArray, n2, cArray, 0, nArray, false);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            CharacterSet.failUTFConversion();
            return "";
        }
    }

    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            char[] cArray = new char[byArray.length];
            int[] nArray = new int[]{n3};
            int n4 = CharacterSet.convertUTFBytesToJavaChars(byArray, n2, cArray, 0, nArray, true);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }
}

