/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverters;

class CharacterSetZHTEUC
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterZHTEUC";
    static final int MAX_7BIT = 127;
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;

    CharacterSetZHTEUC(int n2, CharacterConverters characterConverters) {
        super(n2, characterConverters);
        this.m_leadingCodes = characterConverters.getLeadingCodes();
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2;
        if (characterWalker.next + 1 < characterWalker.bytes.length) {
            n2 = characterWalker.bytes[characterWalker.next] << 8 | characterWalker.bytes[characterWalker.next + 1];
            int n3 = 0;
            while (n3 < this.m_leadingCodes.length) {
                if (n2 == this.m_leadingCodes[n3]) {
                    if (characterWalker.bytes.length - characterWalker.next < 4) {
                        throw new SQLException("destination too small");
                    }
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < 4) {
                        n4 = n4 << 8 | characterWalker.bytes[characterWalker.next++];
                        ++n5;
                    }
                    return n4;
                }
                ++n3;
            }
        }
        n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n2 > 127) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                throw new SQLException("destination too small");
            }
        }
        return n2;
    }

    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = n2 >> 16;
        int n4 = 0;
        while (n4 < this.m_leadingCodes.length) {
            if (n3 == this.m_leadingCodes[n4]) {
                CharacterSet.need(characterBuffer, 4);
                int n5 = 0;
                while (n5 < 4) {
                    characterBuffer.bytes[characterBuffer.next++] = (byte)n2;
                    n2 >>= 8;
                    ++n5;
                }
                return;
            }
            ++n4;
        }
        throw new SQLException();
    }

    static CharacterSetZHTEUC getInstance(int n2, CharacterConverters characterConverters) {
        if (characterConverters.getGroupId() == 5) {
            return new CharacterSetZHTEUC(n2, characterConverters);
        }
        return null;
    }
}

