﻿#ifndef __LOTUS_CARD_DRIVER_H__
#define __LOTUS_CARD_DRIVER_H__

#if 1 //作为VC demo调用头文件 把0改为1
		typedef int		 						BOOL;
		typedef unsigned char		 					byte;
		//#undef FALSE
		//#undef TRUE
		//#undef NULL

		#define FALSE   0
		#define TRUE    1
		#define NULL    0
		#define WINAPI
	#define		RT_NOT_HALT				0x26
	#define		RT_ALL					0x52

	#define		AM_A					0x60
	#define		AM_B					0x61
	typedef BOOL (*LotusCardExtendReadWriteCallBack)(BOOL bRead, unsigned char * pReadWriteBuffer, int nBufferLength);
	typedef struct _LotusCardParamStruct
	{
		/**
		* 卡片类型
		*/
		int nCardType;
		/**
		* 4字节卡号
		*/
		byte arrCardNo[4];
		
		/**
		* 卡片容量大小
		*/
		int nCardSize;
		
		/**
		* 读写缓冲
		*/
		byte arrBuffer[64];

		int nBufferSize;
		
		/**
		* 密钥
		*/
		byte arrKeys[64];
		int nKeysSize;
	}LotusCardParamStruct;
#else
	#include "ISO14443.h"
	#ifdef WIN32
		#include "WINComm.h"
		#include "WINUsb.h"
	#else
		#include "LinuxComm.h"
		#include "LinuxUsb.h"
		typedef int		 						BOOL;
		//#undef FALSE
		//#undef TRUE
		//#undef NULL

		#define FALSE   0
		#define TRUE    1
		//#define NULL    0
		#define WINAPI
	#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

	/**
	 * 打开设备
	 * 
	 * @param strDeviceName
	 *            串口设备名称
	 * @param nVID
	 *            USB设备VID
	 * @param nPID
	 *            USB设备PID
	 * @param pLotusCardExtendReadWriteCallBack 外部读写通道回调函数 只要针对ANDROID 
	 * 			如果没有设备写权限时，可以使用外部USB或串口进行通讯，
	 * 			需要改造callBackProcess中相关代码完成读写工作 目前范例提供USB操作
	 * @return true=成功
	 */
	int WINAPI LotusCardOpenDevice(char * pszDeviceName, int nVID, int nPID, LotusCardExtendReadWriteCallBack  pLotusCardExtendReadWriteCallBack);

	/**
	 * 关闭设备
	 * 
	 * @param nDeviceHandle
	 *            设备句柄
	 */
	void WINAPI LotusCardCloseDevice(int nDeviceHandle);

	/**
	 * 寻卡
	 * 
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nRequestType
	 *            请求类型
	 * @param tLotusCardParam
	 *            结果值 用里面的卡片类型
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardRequest(int nDeviceHandle, int nRequestType,
			LotusCardParamStruct* pLotusCardParam);

	/**
	 * 防冲突
	 * 
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param tLotusCardParam
	 *            结果值 用里面的卡号
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardAnticoll(int nDeviceHandle,
			LotusCardParamStruct* pLotusCardParam);

	/**
	 * 选卡
	 * 
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param tLotusCardParam
	 *            参数(使用里面的卡号)与结果值(使用里面的卡容量大小)
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardSelect(int nDeviceHandle,
			LotusCardParamStruct* pLotusCardParam);

	/**
	 * 密钥验证
	 * 
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nAuthMode
	 *            验证模式
	 * @param nSectionIndex
	 *            扇区索引
	 * @param tLotusCardParam
	 *            参数(使用里面的卡号)
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardAuthentication(int nDeviceHandle, int nAuthMode,
			int nSectionIndex, LotusCardParamStruct* pLotusCardParam);

	/**
	 * 卡片中止响应
	 * 
	 * @param nDeviceHandle
	 *            设备句柄
	 * @return true = 成功
	 */
	BOOL  WINAPI LotusCardHalt(int nDeviceHandle);

	/**
	 * 读指定地址数据
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nAddress 块地址
	 * @param tLotusCardParam 结果值（读写缓冲）
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardRead(int nDeviceHandle, int nAddress, LotusCardParamStruct* pLotusCardParam);
	
	/**
	 * 写指定地址数据
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nAddress 块地址
	 * @param tLotusCardParam 参数（读写缓冲）
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardWrite(int nDeviceHandle, int nAddress, LotusCardParamStruct* pLotusCardParam);
	
	/**
	 * 加值
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nAddress 块地址
	 * @param nValue 值
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardIncrement(int nDeviceHandle, int nAddress, int nValue);
	
	/**
	 * 减值
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nAddress 块地址
	 * @param nValue 值
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardDecrement(int nDeviceHandle, int nAddress,int nValue);
	
	/**
	 * 卡数据块传入卡的内部寄存器
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nAddress 块地址
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardRestore(int nDeviceHandle, int nAddress);
	/**
	 * 内部寄存器传入卡的卡数据块
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nAddress 块地址
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardTransfer(int nDeviceHandle, int nAddress);

	/**
	 * 装载密钥
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nAuthMode 验证模式
	 * @param nSectionIndex 扇区索引
	 * @param tLotusCardParam 参数（密钥）
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardLoadKey(int nDeviceHandle,int nAuthMode, int nSectionIndex, LotusCardParamStruct* pLotusCardParam);
	
	/**
	 * 蜂鸣
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nDeviceHandle 设备句柄
	 * @param nBeepLen 蜂鸣长度 毫秒为单位
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardBeep(int nDeviceHandle, int nBeepLen);

	/**
	 * 发送指令 用于CPU卡
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nTimeOut 超时参数
	 * @param tLotusCardParam 参数（指令缓冲,返回结果）
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardSendCpuCommand(int nDeviceHandle, int nTimeOut, LotusCardParamStruct* pLotusCardParam);

	/********************************以下函数调用上述函数，为了简化第三方调用操作***************************/
	/**
	 * 获取卡号
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nRequestType
	 *            请求类型
	 * @param tLotusCardParam
	 *            结果值 
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardGetCardNo(int nDeviceHandle, int nRequestType,
			LotusCardParamStruct* pLotusCardParam);

	/**
	 * 初始值
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param nAddress 块地址
	 * @param nValue 值
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardInitValue(int nDeviceHandle,  int nAddress, int nValue);

	/**
	 * 修改密码AB
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param pPasswordA 密码A
	 * @param pPasswordB 密码B
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardChangePassword(int nDeviceHandle, int nSectionIndex, const char * pPasswordA, const  char * pPasswordB);

	/**
	 * 设置外部读写函数
	* @param nDeviceHandle
	*            设备句柄
	 * @param pLotusCardExtendReadWriteCallBack 外部读写操作函数
	 * @return 
	 */
	void WINAPI LotusCardSetExtendReadWrite(int nDeviceHandle, LotusCardExtendReadWriteCallBack  pLotusCardExtendReadWriteCallBack);

	/**
	 * 复位CPU卡
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param tLotusCardParam
	 *            结果值 
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardResetCpuCard(int nDeviceHandle, LotusCardParamStruct* pLotusCardParam);

	/**
	 * 发送指令 用于CPU卡 封装LotusCardSendCpuCommand
	 * @param nDeviceHandle
	 *            设备句柄
	 * @param tLotusCardParam 参数（指令缓冲,返回结果）
	 * @return true = 成功
	 */
	BOOL WINAPI LotusCardSendCOSCommand(int nDeviceHandle, LotusCardParamStruct* pLotusCardParam);
#ifdef __cplusplus
}
#endif

#endif//__LOTUS_CARD_DRIVER_H__
