#include "LotusCardDriver.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
void TestIcCard(int hLotusCard);
int main()
{
	BOOL bResult = FALSE;
	int  hLotusCard = LotusCardOpenDevice("",0,0,NULL);
	if( hLotusCard > 0)
	{
		TestIcCard(hLotusCard);
		LotusCardCloseDevice(hLotusCard);
	}
	else
	{
		printf("error %d\r\n", hLotusCard);
	}
	return hLotusCard;
}

void TestIcCard(int hLotusCard)
{
	LotusCardParamStruct sttLotusCardParam;
	BOOL bResult = FALSE;
	bResult = LotusCardBeep(hLotusCard, 10);
	unsigned int nCardNo = 0;
	if(FALSE == bResult) return;
	int nRequestType = RT_NOT_HALT;

      //获取卡号 同执行下面三个函数
      memset(&sttLotusCardParam, 0x00, sizeof(sttLotusCardParam));
      bResult = LotusCardGetCardNo(hLotusCard,nRequestType, &sttLotusCardParam);
      if(FALSE == bResult) return;
	  memcpy(&nCardNo, sttLotusCardParam.arrCardNo, 4);
	  printf("卡号nCardNo 0x%x\r\n", nCardNo);

      //装载密码A
      memset(&sttLotusCardParam.arrKeys, 0x00, sizeof(sttLotusCardParam.arrKeys));
      sttLotusCardParam.arrKeys[0]=0xff;
      sttLotusCardParam.arrKeys[1]=0xff;
      sttLotusCardParam.arrKeys[2]=0xff;
      sttLotusCardParam.arrKeys[3]=0xff;
      sttLotusCardParam.arrKeys[4]=0xff;
      sttLotusCardParam.arrKeys[5]=0xff;
	  sttLotusCardParam.nKeysSize = 6;
      bResult =LotusCardLoadKey(hLotusCard, AM_A, 0, &sttLotusCardParam); 
      if(FALSE == bResult) return;


      //验证密码
      bResult =LotusCardAuthentication(hLotusCard, AM_A, 0, &sttLotusCardParam);
      if(FALSE == bResult) return;

      
      //读
      bResult=LotusCardRead(hLotusCard, 2, &sttLotusCardParam);
      if(FALSE == bResult) return;


      //写
      memset(&sttLotusCardParam.arrBuffer, 0x00, sizeof(sttLotusCardParam.arrBuffer));
      sttLotusCardParam.arrBuffer[0] = 0x00;
      sttLotusCardParam.arrBuffer[1] = 0x01;
      sttLotusCardParam.arrBuffer[2] = 0x02;
      sttLotusCardParam.arrBuffer[3] = 0x03;
      sttLotusCardParam.arrBuffer[4] = 0x04;
      sttLotusCardParam.arrBuffer[5] = 0x05;
      sttLotusCardParam.arrBuffer[6] = 0x06;
      sttLotusCardParam.arrBuffer[7] = 0x07;
      sttLotusCardParam.arrBuffer[8] = 0x08;
      sttLotusCardParam.arrBuffer[9] = 0x09;
      sttLotusCardParam.arrBuffer[10] = 0x0a;
      sttLotusCardParam.arrBuffer[11] = 0x0b;
      sttLotusCardParam.arrBuffer[12] = 0x0c;
      sttLotusCardParam.arrBuffer[13] = 0x0d;
      sttLotusCardParam.arrBuffer[14] = 0x0e;
      sttLotusCardParam.arrBuffer[15] = 0x0f;
      sttLotusCardParam.nBufferSize=16;
      bResult=LotusCardWrite(hLotusCard, 2, &sttLotusCardParam);
      if(FALSE == bResult) return;

      bResult = LotusCardInitValue(hLotusCard, 2, 10);
	  if(FALSE == bResult) return;
      printf("初始化值成功！\r\n");      

      //减值
      bResult=LotusCardDecrement(hLotusCard, 2, 1);
      if(FALSE == bResult) return;
      printf("减值成功！\r\b");
      //中止
      bResult=LotusCardHalt(hLotusCard);
	  if(FALSE == bResult) return;
}
