package org.lionsoul.jcseg.test;

import java.io.IOException;
import java.util.List;

import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.dic.DictionaryFactory;
import org.lionsoul.jcseg.extractor.impl.TextRankKeywordsExtractor;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;

public class KeywordsExtractorTest {

    public static void main(String[] args) 
    {
        //create your JcsegTaskConfig here please
        SegmenterConfig config = new SegmenterConfig(true); 
        config.setClearStopwords(true);
        config.setAppendCJKSyn(false);
        config.setKeepUnregWords(false);
        ADictionary dic = DictionaryFactory.createSingletonDictionary(config);
        
        try {
            ISegment seg = ISegment.COMPLEX.factory.create(config, dic);
            TextRankKeywordsExtractor extractor = new TextRankKeywordsExtractor(seg);
            extractor.setMaxIterateNum(100);
            extractor.setWindowSize(5);
            extractor.setKeywordsNum(15);
            
            String doc = "";
            List<String> keywords;
            /*doc = "当中国南方还处于深秋时节，中国的北方已经下了几场雪了。"
                + "不知道大家在下雪的时候是选择在家上网休息，还是会到户外享受美妙的雪景呢？"
                + "但是小编作为南方人是真的很羡慕北方的孩纸们....  话说回来，"
                + "前两天北京下雪后小编的朋友圈就已经被刷屏了...尽管都是雪景，"
                + "但是大多数人还是从欣赏的角度出发。。。除了这些逗比：其实我们今天要说的事情是这样的，"
                + "最近网络中曝出一组中国人民公安大学学生在大雪天训练的照片...  "
                + "20岁出头的小鲜肉们在此严酷的环境中训练，小编还是替他们的女朋友感到心痛的...   "
                + "但是，作为将来要保家卫国的军人，公安大学的学生们在如此寒冷的天气中赤膊上阵训练更多的是让人振奋！"
                + "在曝光的训练队伍中甚至还有一名女生！  相对于其他男人赤膊上阵，这名女生也仅仅穿了一件T恤！"
                + "让人无比钦佩！  在雪中训练已经成为军人日常训练之一。在北方冬天动辄零下10几度的气温中训练，"
                + "无论对于人的耐力还是毅力都是一个极大的考验。  这样的雪浴训练更是官兵们的必修课：     当然，"
                + "其他常规训练也是必不可少的：     网友评论： @修坡贱：一入警校深似海，从此女票是路人 "
                + "@官庄工区派出所社区大队：抓紧锻炼身体，上班啃老本。女票不女票全都然并卵。 "
                + "@ilovelilybabe：好man好喜欢 @_陈毅勋：我想知道的是后来他们生病了没有。 "
                + "@-Davie-：好想去公安大学看看，不愧为中国第一公安院校，佩服！  相对于雪地训练历史更早的韩国和日本，"
                + "中国对于士兵的雪地训练开展得相对较晚，但是随着中国军人培养机制的日渐成熟，"
                + "雪地训练已经成为学兵和官兵们重要的训练科目！看到祖国的未来在大雪中艰苦的训练，你是怎样的心情呢？"
                + "赶紧分享出去让你的小伙伴们也看到吧！";*/
            //insert you test text here
            /*doc = "《让雷锋精神代代相传》2012年3月5日见报 让雷锋精神代代相传。 "
                + "雷锋具有崇高理想和坚定信念，是实践社会主义、共产主义思想道德的楷模，"
                + "是全国人民学习的光辉榜样。党的十七届六中全会《决定》强调，深入开展学雷锋活动，"
                + "采取措施推动学习活动常态化。贯彻落实这一要求，需要我们深刻理解雷锋精神的时代内涵，"
                + "积极探索新形势下弘扬雷锋精神的有效途径，让雷锋精神代代相传。"
                + "这对于推动社会主义核心价值体系建设、巩固全党全国人民团结奋斗的共同思想道德基础具有重要意义。"
                + "本期“大家论道”刊发的这组文章，围绕这一问题进行了阐述。 "
                + "雷锋精神的时代内涵 雷锋这个响亮的名字和以他的名字命名的雷锋精神，深深镌刻在一代又一代中国人的心中，"
                + "影响和激励着一代又一代中国人为建设中国特色社会主义而奋勇前进。"
                + "半个世纪过去了，在雷锋精神的感召下，我国涌现出无数雷锋式的先进人物，他们继承和弘扬雷锋精神，"
                + "为其注入了新的内涵。雷锋精神的时代内涵，集中体现为服务人民、助人为乐的奉献精神，"
                + "干一行爱一行、专一行精一行的敬业精神，锐意进取、自强不息的创新精神，艰苦奋斗、"
                + "勤俭节约的创业精神。【详细】 新时期弘扬雷锋精神的着力点 雷锋精神内涵丰富，历久弥新。"
                + "在新的历史条件下，弘扬雷锋精神应把握以下几个主要着力点。 "
                + "不断坚定中国特色社会主义理想信念 雷锋是一个立场坚定的共产主义战士。"
                + "雷锋说过：“我就是长着一个心眼，我一心向着党，向着社会主义，向着共产主义”；"
                + "“有人说：人生在世，吃好、穿好、玩好是最幸福的。我觉得人生在世，只有勤劳，发愤图强，"
                + "用自己的双手创造财富，为人类的解放事业——共产主义贡献自己的一切，这才是最幸福的”。"
                + "这是雷锋对共产主义忠诚信仰的鲜明表达。坚定的共产主义信仰是雷锋精神的精髓。"
                + "在坚定的共产主义信仰引领下，雷锋的一言一行、一举一动都表现了一个革命战士、"
                + "gongchandang(写成汉字博客园不让发表)人为实现共产主义伟大理想而不懈奋斗的崇高精神。"
                + "【详细】 以学雷锋推动社会主义核心价值体系建设 党的十七届六中全会《决定》强调，"
                + "深入开展学雷锋活动，采取措施推动学习活动常态化。深入贯彻落实全会精神，"
                + "一项重要任务就是引导广大干部群众积极开展学雷锋活动，推动社会主义核心价值体系建设，"
                + "不断巩固全党全国各族人民团结奋斗的共同思想道德基础。 "
                + "开展学雷锋活动对社会主义核心价值体系建设具有重要推动作用 雷锋是中华民族的道德标杆。"
                + "深入开展学雷锋活动，充分发挥道德模范人物的示范效应，对于推动社会主义核心价值体系建设具有重要作用。";*/
        
            doc = "《宁要“不完美”的改革 不要不改革的危机》2012年2月23日见报 "
                + "宁要“不完美”的改革 不要不改革的危机。 无论方案多么周密、智慧多么高超，"
                + "改革总会引起一些非议：既得利益者会用优势话语权阻碍改革，"
                + "媒体公众会带着挑剔目光审视改革，一些人甚至还会以乌托邦思维苛求改革。对于改革者来说，"
                + "认真听取民意，又不为流言所动，既需要智慧和审慎，更要有勇气与担当 自1978年至今，"
                + "中国的改革已如舟至中流，有了更开阔的行进空间，也面临着“中流击水、浪遏飞舟”的挑战。 "
                + "发展起来的问题、公平正义的焦虑、路径锁定的忧叹……在邓小平南方谈话20周年、"
                + "党的十八大即将召开之际，人们对改革的普遍关切，标注着30多年来以开放为先导的改革进入了新的历史方位。 "
                + "冲破思想藩篱、触动现实利益，改革从一开始就挑战着既定格局，也无可避免地伴随着“不同声音”。"
                + "无论当年的联产承包、物价闯关、工资闯关，还是今天的官员财产公示、垄断行业改革、事业单位改革，"
                + "改革总是在争议乃至非议中前行。 所不同的是，从“摸着石头过河”到“改革顶层设计”，从经济领域到社会政治领域，"
                + "改革越是向前推进，所触及的矛盾就越深，涉及的利益就越复杂，碰到的阻力也就越大。用一句通俗的话来讲，"
                + "容易的都改得差不多了，剩下的全是难啃的“硬骨头”，不能回避也无法回避。 "
                + "改革就会招惹是非，改革就是“自找麻烦”，改革也很难十全十美。30多年后，身处深水区和攻坚期，"
                + "无论方案多么周密、智慧多么高超，改革总会引起一些非议：既得利益者会用优势话语权阻碍改革，"
                + "媒体公众会带着挑剔目光审视改革，一些人甚至还会以乌托邦思维苛求改革。对于改革者来说，认真听取民意，"
                + "又不为流言所动，既需要智慧和审慎，更要有勇气与担当。 在改革进程中，可怕的不是反对声音的出现，"
                + "而是一出现不同声音，改革就戛然而止。现实中，或是囿于既得利益的阻力，或是担心不可掌控的风险，"
                + "或是陷入“不稳定幻象”，在一些人那里，改革的“渐进”逐渐退化为“不进”，"
                + "“积极稳妥”往往变成了“稳妥”有余而“积极”不足。这些年来，一些地方改革久议不决，一些部门改革决而难行，"
                + "一些领域改革行而难破，莫不与此有关。 然而，“改革有风险，但不改革党就会有危险”。"
                + "纵观世界一些大党大国的衰落，一个根本原因就是只有修修补补的机巧，没有大刀阔斧的魄力，"
                + "最终因改革停滞而走入死胡同。对于当前各地各部门千头万绪的改革来说，面对“躲不开、绕不过”的体制机制障碍，"
                + "如果怕这怕那、趑趄不前，抱着“多一事不如少一事”的消极态度，甚至将问题矛盾击鼓传花，固然可以求得一时轻松、"
                + "周全某些利益，但只能把问题拖延成历史问题，让危机跑在了改革前面，最终引发更多矛盾、酿成更大危机，"
                + "甚至落入所谓“转型期陷阱”。 小平同志在20多年前就曾告诫：“不要怕冒一点风险。我们已经形成了一种能力，"
                + "承担风险的能力”，“改革开放越前进，承担和抵抗风险的能力就越强。我们处理问题，要完全没有风险不可能，"
                + "冒点风险不怕”。事实上，从改革开放之初的崩溃边缘，到南方谈话前的历史徘徊，我们党正是着眼于国家和人民的未来，"
                + "以“天变不足畏，祖宗不足法，人言不足恤”的改革精神，敢于抓住主要矛盾、勇于直面风险考验，才能化危为机，"
                + "推动改革开放巨轮劈波斩浪，让中国成为了世界第二大经济体。 宁要微词，不要危机；宁要“不完美”的改革，"
                + "不要不改革的危机。一个长期执政的大党，尤其要时刻警惕短期行为损害执政根基，防止局部利益左右发展方向，"
                + "力避消极懈怠延误改革时机，所思所虑不独是当前社会的发展稳定，更有党和国家事业的长治久安。面对全新的改革历史方位，"
                + "当以“不畏浮云遮望眼”的宽广视野，以无私无畏的责任担当，按照hujintao总书记所要求的，"
                + "“不失时机地推进重要领域和关键环节改革”，“继续推进经济体制、政治体制、文化体制、社会体制改革创新”。"
                + "如此，我们就一定能把风险化解在当下，让发展乘势而上，为党和国家赢得一个光明的未来。 ";
            keywords = extractor.getKeywordsFromString(doc);
            //keywords = extractor.getKeywordsFromFile("/home/chenxin/curpos/1.txt");
            System.out.println(keywords);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
