/*
 * Decompiled with CFR 0.152.
 */
package contrib.javapro;

import contrib.javapro.SortHeaderRenderer;
import contrib.javapro.SortTableModel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class JSortTable
extends JTable
implements MouseListener {
    protected int sortedColumnIndex = -1;
    protected boolean sortedColumnAscending = true;

    public JSortTable(SortTableModel sortTableModel) {
        super(sortTableModel);
        this.initSortHeader();
    }

    public JSortTable(SortTableModel sortTableModel, TableColumnModel tableColumnModel) {
        super(sortTableModel, tableColumnModel);
        this.initSortHeader();
    }

    public JSortTable(SortTableModel sortTableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(sortTableModel, tableColumnModel, listSelectionModel);
        this.initSortHeader();
    }

    protected void initSortHeader() {
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setDefaultRenderer(new SortHeaderRenderer());
        jTableHeader.addMouseListener(this);
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    public boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = tableColumnModel.getColumn(n).getModelIndex();
        SortTableModel sortTableModel = (SortTableModel)this.getModel();
        if (sortTableModel.isSortable(n2)) {
            if (this.sortedColumnIndex == n) {
                this.sortedColumnAscending = !this.sortedColumnAscending;
            }
            this.sortedColumnIndex = n;
            sortTableModel.sortColumn(n2, this.sortedColumnAscending);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

