/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.event;

import java.util.HashMap;
import java.util.Hashtable;
import rero.bridges.event.CodeSnippet;
import rero.bridges.event.EventChatListener;
import rero.bridges.event.FilterChatListener;
import rero.bridges.event.GeneralChatListener;
import rero.bridges.event.PredicateChatListener;
import rero.bridges.event.PrivateChatListener;
import rero.bridges.event.PublicChatListener;
import rero.bridges.event.ScriptedEventListener;
import rero.ircfw.ChatFramework;
import rero.ircfw.interfaces.ChatListener;
import sleep.engine.Block;
import sleep.engine.atoms.Check;
import sleep.interfaces.Environment;
import sleep.interfaces.FilterEnvironment;
import sleep.interfaces.Loadable;
import sleep.interfaces.PredicateEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class EventBridge
implements Loadable,
Environment,
PredicateEnvironment,
FilterEnvironment {
    protected HashMap listeners = new HashMap();
    protected ChatFramework framework;
    protected HashMap registeredEvents = new HashMap();
    protected HashMap unloadEvents = new HashMap();

    public void announceFramework(ChatFramework chatFramework) {
        this.framework = chatFramework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scriptUnloaded(ScriptInstance scriptInstance) {
        if (this.unloadEvents.get(scriptInstance) != null) {
            Block block = (Block)this.unloadEvents.get(scriptInstance);
            this.unloadEvents.remove(scriptInstance);
            ScriptVariables scriptVariables = scriptInstance.getScriptEnvironment().getScriptVariables();
            synchronized (scriptVariables) {
                scriptInstance.getScriptEnvironment().getScriptVariables().pushLocalLevel();
                SleepUtils.runCode(block, scriptInstance.getScriptEnvironment());
                scriptInstance.getScriptEnvironment().getScriptVariables().popLocalLevel();
            }
        }
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        Hashtable hashtable = scriptInstance.getScriptEnvironment().getEnvironment();
        hashtable.put("on", this);
        hashtable.put("wait", this);
    }

    public void registerEvent(String string, ScriptedEventListener scriptedEventListener) {
        this.registeredEvents.put(string.toUpperCase(), scriptedEventListener);
    }

    protected EventChatListener getNewListenerFor(String string) {
        if (string.equals("PUBLIC")) {
            return new PublicChatListener("PRIVMSG");
        }
        if (string.equals("PUBLIC_ACTION")) {
            return new PublicChatListener("ACTION");
        }
        if (string.equals("PRIVATE_ACTION")) {
            return new PrivateChatListener("ACTION");
        }
        if (string.equals("MSG")) {
            return new PrivateChatListener("PRIVMSG");
        }
        if (string.length() > 6 && string.substring(0, 5).equals("REPL_")) {
            return new GeneralChatListener(string.substring(5, string.length()));
        }
        return new GeneralChatListener(string);
    }

    protected EventChatListener getListenerFor(String string) {
        if (this.listeners.get(string) == null) {
            this.listeners.put(string, this.getNewListenerFor(string));
            this.framework.addChatListener((ChatListener)this.listeners.get(string));
        }
        return (EventChatListener)this.listeners.get(string);
    }

    public void bindFilteredFunction(ScriptInstance scriptInstance, String string, String string2, String string3, Block block) {
        FilterChatListener filterChatListener = new FilterChatListener(scriptInstance.getScriptEnvironment(), string2, string3, new CodeSnippet(block, scriptInstance.getScriptEnvironment()));
        if (string.equals("on")) {
            this.framework.addChatListener(filterChatListener);
        }
        if (string.equals("wait")) {
            filterChatListener.setFlags(4);
            this.framework.addTemporaryListener(filterChatListener);
        }
    }

    public void bindPredicate(ScriptInstance scriptInstance, String string, Check check, Block block) {
        PredicateChatListener predicateChatListener = new PredicateChatListener(scriptInstance.getScriptEnvironment(), check, new CodeSnippet(block, scriptInstance.getScriptEnvironment()));
        if (string.equals("on")) {
            this.framework.addChatListener(predicateChatListener);
        }
        if (string.equals("wait")) {
            predicateChatListener.setFlags(4);
            this.framework.addTemporaryListener(predicateChatListener);
        }
    }

    public void bindFunction(ScriptInstance scriptInstance, String string, String string2, Block block) {
        string2 = string2.toUpperCase();
        if (string.equals("on") && string2.equals("UNLOAD")) {
            this.unloadEvents.put(scriptInstance, block);
        } else {
            if (this.registeredEvents.get(string2) != null) {
                ScriptedEventListener scriptedEventListener = (ScriptedEventListener)this.registeredEvents.get(string2);
                if (!scriptedEventListener.isSetup()) {
                    scriptedEventListener.setupListener();
                    scriptedEventListener.setRegistered();
                }
                if (string.equals("on")) {
                    scriptedEventListener.addListener(new CodeSnippet(block, scriptInstance.getScriptEnvironment()));
                }
                if (string.equals("wait")) {
                    scriptedEventListener.addTemporaryListener(new CodeSnippet(block, scriptInstance.getScriptEnvironment()));
                }
                return;
            }
            if (string.equals("on")) {
                EventChatListener eventChatListener = this.getListenerFor(string2);
                eventChatListener.addListener(new CodeSnippet(block, scriptInstance.getScriptEnvironment()));
            } else if (string.equals("wait")) {
                EventChatListener eventChatListener = this.getNewListenerFor(string2);
                eventChatListener.addListener(new CodeSnippet(block, scriptInstance.getScriptEnvironment()));
                eventChatListener.setFlags(4);
                this.framework.addTemporaryListener(eventChatListener);
            }
        }
    }
}

