/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.event;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import rero.bridges.event.CodeSnippet;

public abstract class ScriptedEventListener {
    protected boolean registered = false;
    protected List temporary = new LinkedList();
    protected List permanent = new LinkedList();

    public int dispatchEvent(HashMap hashMap) {
        int n = this.easyDispatch(this.temporary, hashMap);
        if (n == 1) {
            n = this.easyDispatch(this.permanent, hashMap);
        }
        return n;
    }

    private int easyDispatch(List list, HashMap hashMap) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            CodeSnippet codeSnippet = (CodeSnippet)listIterator.next();
            if (codeSnippet.isValid()) {
                int n;
                if (list == this.temporary) {
                    listIterator.remove();
                }
                if (((n = codeSnippet.execute(hashMap)) & 4) == 4 && list != this.temporary) {
                    listIterator.remove();
                }
                if ((n & 2) != 2) continue;
                return 2;
            }
            listIterator.remove();
        }
        return 1;
    }

    public void addTemporaryListener(CodeSnippet codeSnippet) {
        this.temporary.add(codeSnippet);
    }

    public void addListener(CodeSnippet codeSnippet) {
        this.permanent.add(codeSnippet);
    }

    public abstract void setupListener();

    public boolean isSetup() {
        return this.registered;
    }

    public void setRegistered() {
        this.registered = true;
    }
}

