/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.menu;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Stack;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import rero.bridges.menu.MenuBridgeParent;
import rero.bridges.menu.ScriptedItem;
import rero.bridges.menu.ScriptedMenu;
import rero.bridges.menu.ScriptedPopupMenu;
import rero.bridges.menu.SimpleItem;
import sleep.engine.Block;
import sleep.interfaces.Environment;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;

public class MenuBridge
implements Environment,
Function,
Loadable {
    protected static String WINDOW_MENU = "&Window";
    protected static String HELP_MENU = "&Help";
    protected static Stack ParentMenu = new Stack();
    protected LinkedHashMap menubarMenus = new LinkedHashMap(10, 0.75f, false);
    protected HashMap menus = new HashMap();

    public static void SetParent(MenuBridgeParent menuBridgeParent) {
        ParentMenu.push(menuBridgeParent);
    }

    public static MenuBridgeParent GetParent() {
        return (MenuBridgeParent)ParentMenu.peek();
    }

    public static void FinishParent() {
        ParentMenu.pop();
    }

    protected static boolean isTopLevel(String string) {
        if ((string = string.toLowerCase()).length() > 2 && string.substring(0, 2).equals("__")) {
            return true;
        }
        return string.equals("list") || string.equals("dcc") || string.equals("switchbar") || string.equals("nicklist") || string.equals("status") || string.equals("channel") || string.equals("query") || string.equals("input") || string.equals("chat") || string.equals("tab") || string.equals("background");
    }

    protected static boolean isSpecialMenu(String string) {
        return string.equals(WINDOW_MENU) || string.equals(HELP_MENU);
    }

    public void bindFunction(ScriptInstance scriptInstance, String string, String string2, Block block) {
        if (string.equals("menubar")) {
            if (this.menubarMenus.containsKey(string2)) {
                ((ScriptedMenu)this.menubarMenus.get(string2)).installCode(scriptInstance, block);
            } else if (MenuBridge.isSpecialMenu(string2)) {
                if (this.menus.containsKey(string2)) {
                    ((ScriptedMenu)this.menus.get(string2)).installCode(scriptInstance, block);
                } else {
                    this.menus.put(string2, new ScriptedMenu(scriptInstance, string2, block));
                }
            } else {
                this.menubarMenus.put(string2, new ScriptedMenu(scriptInstance, string2, block));
            }
        }
        if (string.equals("menu")) {
            if (MenuBridge.isTopLevel(string2.toUpperCase())) {
                if (this.menus.containsKey(string2.toUpperCase())) {
                    ((ScriptedPopupMenu)this.menus.get(string2.toUpperCase())).installCode(scriptInstance, block);
                } else {
                    this.menus.put(string2.toUpperCase(), new ScriptedPopupMenu(scriptInstance, block));
                }
            } else {
                MenuBridge.GetParent().add(new ScriptedMenu(scriptInstance, string2, block));
            }
        }
        if (string.equals("item")) {
            MenuBridge.GetParent().add(new ScriptedItem(scriptInstance, string2, block));
        }
    }

    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&addSeparator")) {
            MenuBridge.GetParent().addSeparator();
        } else if (string.equals("&addItem") && stack.size() == 2) {
            String string2 = ((Scalar)stack.pop()).stringValue();
            String string3 = ((Scalar)stack.pop()).stringValue();
            MenuBridge.GetParent().add(new SimpleItem(scriptInstance, string2, string3));
        } else if (string.equals("&removeMenubarItem") && stack.size() == 1) {
            String string4 = ((Scalar)stack.pop()).stringValue();
            this.menus.remove(string4);
        }
        return null;
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        Hashtable hashtable = scriptInstance.getScriptEnvironment().getEnvironment();
        hashtable.put("item", this);
        hashtable.put("menu", this);
        hashtable.put("menubar", this);
        hashtable.put("&addItem", this);
        hashtable.put("&addSeparator", this);
        hashtable.put("&removeMenubarItem", this);
    }

    public JPopupMenu getPopupMenu(String string, HashMap hashMap) {
        if (!this.menus.containsKey(string.toUpperCase())) {
            return null;
        }
        ScriptedPopupMenu.SetMenuData(hashMap);
        JPopupMenu jPopupMenu = (JPopupMenu)this.menus.get(string.toUpperCase());
        return jPopupMenu;
    }

    public JPopupMenu getPrimaryPopup(String string) {
        if (!this.menubarMenus.containsKey(string)) {
            return null;
        }
        ScriptedPopupMenu.SetMenuData(new HashMap());
        ScriptedMenu scriptedMenu = (ScriptedMenu)this.menubarMenus.get(string);
        return scriptedMenu.getScriptedPopupMenu();
    }

    public void installMenubar(JMenuBar jMenuBar) {
        Iterator iterator = this.menubarMenus.values().iterator();
        while (iterator.hasNext()) {
            ScriptedMenu scriptedMenu = (ScriptedMenu)iterator.next();
            if (scriptedMenu.isValidCode()) {
                jMenuBar.add(scriptedMenu);
                continue;
            }
            iterator.remove();
        }
        if (this.menus.containsKey(WINDOW_MENU)) {
            jMenuBar.add((JMenu)this.menus.get(WINDOW_MENU));
        }
        if (this.menus.containsKey(HELP_MENU)) {
            jMenuBar.add((JMenu)this.menus.get(HELP_MENU));
        }
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }
}

