/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.menu;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import rero.bridges.menu.CodeSnippet;
import rero.bridges.menu.MenuBridge;
import rero.bridges.menu.MenuBridgeParent;
import rero.script.ScriptCore;
import sleep.engine.Block;
import sleep.runtime.ScriptInstance;

public class ScriptedPopupMenu
extends JPopupMenu
implements PopupMenuListener,
MenuBridgeParent {
    protected static HashMap MenuData = null;
    protected LinkedList code;

    public static void SetMenuData(HashMap hashMap) {
        if (hashMap != null) {
            MenuData = hashMap;
        }
    }

    public static HashMap getMenuData() {
        return MenuData;
    }

    public static void FinishMenuData() {
        MenuData = null;
    }

    public ScriptedPopupMenu(ScriptInstance scriptInstance, Block block) {
        this.code = new LinkedList();
        this.installCode(scriptInstance, block);
        this.addPopupMenuListener(this);
    }

    public ScriptedPopupMenu(LinkedList linkedList) {
        this.code = linkedList;
        this.addPopupMenuListener(this);
    }

    public void installCode(ScriptInstance scriptInstance, Block block) {
        this.code.add(new CodeSnippet(scriptInstance, block));
    }

    public boolean isValidCode() {
        Iterator iterator = this.code.iterator();
        while (iterator.hasNext()) {
            CodeSnippet codeSnippet = (CodeSnippet)iterator.next();
            if (codeSnippet.getOwner().isLoaded()) continue;
            iterator.remove();
        }
        return this.code.size() > 0;
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        MenuBridge.SetParent(this);
        Iterator iterator = this.code.iterator();
        while (iterator.hasNext()) {
            CodeSnippet codeSnippet = (CodeSnippet)iterator.next();
            if (codeSnippet.getOwner().isLoaded()) {
                ScriptCore.runCode(codeSnippet.getOwner(), codeSnippet.getBlock(), MenuData);
                continue;
            }
            iterator.remove();
        }
        MenuBridge.FinishParent();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.removeAll();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.removeAll();
    }
}

