/*
 * Decompiled with CFR 0.152.
 */
package rero.client;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.WeakHashMap;
import rero.client.Feature;
import rero.client.data.DataStructureBridge;
import rero.client.dcc.FeatureDCC;
import rero.client.dcc.LocalInfo;
import rero.client.functions.BuiltInOperators;
import rero.client.functions.ChannelOperators;
import rero.client.functions.ConfigOperators;
import rero.client.functions.DCCOperators;
import rero.client.functions.NotifyOperators;
import rero.client.functions.ServerOperators;
import rero.client.functions.SoundOperators;
import rero.client.functions.TimerOperators;
import rero.client.functions.TokenOperators;
import rero.client.functions.UserOperators;
import rero.client.functions.UtilOperators;
import rero.client.listeners.InternalEvents;
import rero.client.notify.NotifyData;
import rero.client.output.ChatCapabilities;
import rero.client.output.OutputCapabilities;
import rero.client.script.ScriptManager;
import rero.client.server.PerformOnConnect;
import rero.client.server.ProcessEvents;
import rero.client.server.ServerHandler;
import rero.client.user.ClientCommand;
import rero.client.user.UserHandler;
import rero.gui.GlobalCapabilities;
import rero.gui.SessionManager;
import rero.gui.UICapabilities;
import rero.ircfw.ChatFramework;
import rero.ircfw.interfaces.ChatListener;
import rero.net.SocketConnection;
import rero.script.ScriptCore;
import rero.util.TimerUtil;

public class Capabilities {
    protected SocketConnection socket;
    protected ChatFramework ircfw;
    protected ScriptCore script;
    protected OutputCapabilities output;
    protected ChatCapabilities actions;
    protected UICapabilities gui;
    protected static TimerUtil timer;
    protected WeakHashMap data;
    protected LinkedList featureList;

    public Capabilities(ChatFramework chatFramework, SocketConnection socketConnection, ScriptCore scriptCore, UICapabilities uICapabilities, WeakHashMap weakHashMap) {
        this.ircfw = chatFramework;
        this.socket = socketConnection;
        this.script = scriptCore;
        this.gui = uICapabilities;
        this.data = weakHashMap;
        if (timer == null) {
            timer = new TimerUtil();
            timer.start();
        }
        this.featureList = new LinkedList();
        this.output = new OutputCapabilities();
        this.setupFeature(this.output, this.featureList);
        this.actions = new ChatCapabilities();
        this.setupFeature(this.actions, this.featureList);
        UserHandler userHandler = new UserHandler();
        this.setupFeature(userHandler, this.featureList);
        ServerHandler serverHandler = new ServerHandler();
        this.setupFeature(serverHandler, this.featureList);
        FeatureDCC featureDCC = new FeatureDCC();
        this.setupFeature(featureDCC, this.featureList);
        ProcessEvents processEvents = new ProcessEvents();
        this.setupFeature(processEvents, this.featureList);
        NotifyData notifyData = new NotifyData();
        this.setupFeature(notifyData, this.featureList);
        InternalEvents internalEvents = new InternalEvents();
        this.setupFeature(internalEvents, this.featureList);
        LocalInfo localInfo = new LocalInfo();
        this.setupFeature(localInfo, this.featureList);
        ScriptManager scriptManager = new ScriptManager();
        this.setupFeature(scriptManager, this.featureList);
        PerformOnConnect performOnConnect = new PerformOnConnect();
        this.setupFeature(performOnConnect, this.featureList);
        DataStructureBridge dataStructureBridge = new DataStructureBridge();
        this.setupFeature(dataStructureBridge, this.featureList);
        ChannelOperators channelOperators = new ChannelOperators();
        this.setupFeature(channelOperators, this.featureList);
        this.script.addBridge(channelOperators);
        UserOperators userOperators = new UserOperators();
        this.setupFeature(userOperators, this.featureList);
        this.script.addBridge(userOperators);
        BuiltInOperators builtInOperators = new BuiltInOperators();
        this.setupFeature(builtInOperators, this.featureList);
        this.script.addBridge(builtInOperators);
        NotifyOperators notifyOperators = new NotifyOperators();
        this.setupFeature(notifyOperators, this.featureList);
        this.script.addBridge(notifyOperators);
        TimerOperators timerOperators = new TimerOperators();
        this.setupFeature(timerOperators, this.featureList);
        ConfigOperators configOperators = new ConfigOperators();
        this.setupFeature(configOperators, this.featureList);
        DCCOperators dCCOperators = new DCCOperators();
        this.setupFeature(dCCOperators, this.featureList);
        UtilOperators utilOperators = new UtilOperators();
        this.setupFeature(utilOperators, this.featureList);
        TokenOperators tokenOperators = new TokenOperators();
        this.setupFeature(tokenOperators, this.featureList);
        ServerOperators serverOperators = new ServerOperators();
        this.setupFeature(serverOperators, this.featureList);
        SoundOperators soundOperators = new SoundOperators();
        this.setupFeature(soundOperators, this.featureList);
        this.finalizeFeatures(this.featureList);
    }

    public TimerUtil getTimer() {
        return timer;
    }

    public void cleanup() {
        ListIterator listIterator = this.featureList.listIterator();
        while (listIterator.hasNext()) {
            Feature feature = (Feature)listIterator.next();
            feature.cleanup();
        }
        this.data.clear();
        this.featureList.clear();
    }

    public boolean isConnected() {
        return this.socket.getSocketInformation().isConnected;
    }

    public ChatCapabilities getChatCapabilities() {
        return this.actions;
    }

    public OutputCapabilities getOutputCapabilities() {
        return this.output;
    }

    public UICapabilities getUserInterface() {
        return this.gui;
    }

    public ScriptCore getScriptCore() {
        return this.script;
    }

    public SocketConnection getSocketConnection() {
        return this.socket;
    }

    public void sendln(String string) {
        this.socket.println(string);
    }

    public Object getDataStructure(String string) {
        return this.data.get(string);
    }

    public void injectEvent(String string) {
        this.ircfw.injectEvent(string);
    }

    public void dispatchEvent(HashMap hashMap) {
        this.ircfw.getProtocolDispatcher().dispatchEvent(hashMap);
    }

    public void addChatListener(ChatListener chatListener) {
        this.ircfw.addChatListener(chatListener);
    }

    public void addTemporaryListener(ChatListener chatListener) {
        this.ircfw.addTemporaryListener(chatListener);
    }

    public ChatFramework getChatFramework() {
        return this.ircfw;
    }

    public void registerCommand(String string, ClientCommand clientCommand) {
        UserHandler userHandler = (UserHandler)this.getDataStructure("commands");
        userHandler.registerCommand(string, clientCommand);
    }

    public void setupFeature(Feature feature, LinkedList linkedList) {
        feature.storeDataStructures(this.data);
        feature.installCapabilities(this);
        linkedList.add(feature);
    }

    public void finalizeFeatures(LinkedList linkedList) {
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            Feature feature = (Feature)listIterator.next();
            feature.init();
        }
    }

    public GlobalCapabilities getGlobalCapabilities() {
        return SessionManager.getGlobalCapabilities();
    }
}

