/*
 * Decompiled with CFR 0.152.
 */
package rero.client.dcc;

import java.io.File;
import java.util.HashMap;
import java.util.WeakHashMap;
import rero.client.Feature;
import rero.client.dcc.LocalInfo;
import rero.client.functions.DCCOperators;
import rero.client.user.ClientCommand;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.dcc.Chat;
import rero.dcc.ConnectDCC;
import rero.dcc.DCCUtilities;
import rero.dcc.DataDCC;
import rero.dcc.GenericDCC;
import rero.dcc.ListenDCC;
import rero.dcc.Receive;
import rero.dcc.Send;
import rero.dialogs.DialogUtilities;
import rero.dialogs.dcc.ChatRequest;
import rero.dialogs.dcc.SendRequest;
import rero.ircfw.ChatFramework;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.ClientUtils;
import rero.util.TokenizedString;

public class FeatureDCC
extends Feature
implements ClientCommand,
ChatListener,
FrameworkConstants {
    protected ChatFramework ircfw;
    protected DataDCC dccData = new DataDCC();
    protected LocalInfo localInfo;

    public void storeDataStructures(WeakHashMap weakHashMap) {
        weakHashMap.put("dcc", this.dccData);
    }

    public void init() {
        this.ircfw = this.getCapabilities().getChatFramework();
        this.localInfo = (LocalInfo)this.getCapabilities().getDataStructure("localInfo");
        this.getCapabilities().addChatListener(this);
        this.getCapabilities().registerCommand("DCC", this);
        this.getCapabilities().registerCommand("SEND", this);
        this.getCapabilities().registerCommand("CHAT", this);
    }

    public void requestChat(String string) {
        Chat chat = new Chat(string);
        ListenDCC listenDCC = new ListenDCC();
        listenDCC.announceFramework(this.ircfw);
        listenDCC.setImplementation(chat);
        int n = listenDCC.getListenerPort();
        if (n > -1) {
            String string2 = "PRIVMSG " + string + " :" + '\u0001' + "DCC CHAT chat " + ClientUtils.longip(this.localInfo.localip()) + " " + n + "" + '\u0001' + "";
            this.getCapabilities().getOutputCapabilities().fireSetConfused(ClientUtils.getEventHashMap(string, "CHAT " + n), string, "reply", "SEND_DCC");
            this.getCapabilities().sendln(string2);
            this.dccData.addConnection(n + "", listenDCC);
            listenDCC.connect();
        } else {
            listenDCC.getImplementation().fireError("unable to establish a port");
        }
    }

    public void sendFile(String string, File file) {
        Send send = new Send(string, file);
        ListenDCC listenDCC = new ListenDCC();
        listenDCC.announceFramework(this.ircfw);
        listenDCC.setImplementation(send);
        int n = listenDCC.getListenerPort();
        if (n > -1) {
            String string2 = file.getName();
            if (ClientState.getClientState().isOption("dcc.fillspaces", true)) {
                string2 = string2.replace(' ', '_');
            }
            String string3 = "PRIVMSG " + string + " :" + '\u0001' + "DCC SEND " + string2 + " " + ClientUtils.longip(this.localInfo.localip()) + " " + n + " " + file.length() + '\u0001' + "";
            this.getCapabilities().getOutputCapabilities().fireSetConfused(ClientUtils.getEventHashMap(string, "SEND " + n + " " + file.length() + " " + file.getAbsolutePath()), string, "reply", "SEND_DCC");
            this.getCapabilities().sendln(string3);
            this.dccData.addConnection(n + "", listenDCC);
            listenDCC.connect();
        } else {
            listenDCC.getImplementation().fireError("unable to establish a port");
        }
    }

    public void runAlias(String string, String string2) {
        File file;
        if ((string = string.toLowerCase()).equals("send") || string.equals("chat")) {
            this.runAlias("dcc", string + " " + string2);
            return;
        }
        if (!string.equals("dcc")) {
            return;
        }
        TokenizedString tokenizedString = new TokenizedString(string2);
        tokenizedString.tokenize(" ");
        if (tokenizedString.getToken(0).equals("stats")) {
            this.getCapabilities().getUserInterface().openDCCWindow();
        } else if (tokenizedString.getToken(0).equals("chat")) {
            this.requestChat(tokenizedString.getToken(1));
        } else if (tokenizedString.getToken(0).equals("close")) {
            if (tokenizedString.getToken(1).charAt(0) == '=') {
                this.dccData.closeChat(tokenizedString.getToken(1).substring(1, tokenizedString.getToken(1).length()));
            } else if (tokenizedString.getTotalTokens() == 3) {
                int n = DCCOperators.getType(tokenizedString.getToken(1));
                this.dccData.closeConnection(tokenizedString.getToken(2), n);
            } else {
                this.dccData.closeConnection(tokenizedString.getToken(1));
            }
        } else if (tokenizedString.getToken(0).equals("accept")) {
            ConnectDCC connectDCC = (ConnectDCC)this.dccData.getConnectionToAccept(tokenizedString.getToken(1));
            if (tokenizedString.getTotalTokens() >= 3 && connectDCC.getImplementation() instanceof Receive) {
                ((Receive)connectDCC.getImplementation()).setFile(new File(tokenizedString.getToken(2)));
            }
            if (connectDCC != null) {
                connectDCC.connect();
            }
        } else if (tokenizedString.getToken(0).equals("send") && (file = tokenizedString.getTotalTokens() == 2 || !new File(tokenizedString.getToken(2)).exists() ? DialogUtilities.showFileDialog("Send File", "Accept", null) : ClientUtils.getFile(tokenizedString.getToken(2))) != null && file.exists()) {
            this.sendFile(tokenizedString.getToken(1), file);
        }
    }

    public boolean isChatEvent(String string, HashMap hashMap) {
        String string2 = (String)hashMap.get("$parms");
        return string.equals("REQUEST") && string2.substring(0, 3).equals("DCC");
    }

    public int fireChatEvent(HashMap hashMap) {
        TokenizedString tokenizedString = new TokenizedString(hashMap.get("$parms").toString());
        tokenizedString.tokenize(" ");
        if (tokenizedString.getToken(1).equals("CHAT")) {
            boolean bl;
            int n = Integer.parseInt(tokenizedString.getToken(4));
            String string = ClientUtils.longip(tokenizedString.getToken(3));
            if (n <= 0 || n == 19) {
                return 1;
            }
            Chat chat = new Chat(hashMap.get("$nick").toString());
            ConnectDCC connectDCC = new ConnectDCC(string, n);
            connectDCC.announceFramework(this.ircfw);
            connectDCC.setImplementation(chat);
            this.dccData.addConnection(n + "", connectDCC);
            boolean bl2 = ClientState.getClientState().getInteger("dcc.onchat", 0) == 0 && ChatRequest.showDialog(this.getCapabilities().getGlobalCapabilities().getFrame(), connectDCC);
            boolean bl3 = bl = ClientState.getClientState().getInteger("dcc.onchat", 0) == 1;
            if (bl2 || bl) {
                connectDCC.connect();
            }
        } else if (tokenizedString.getToken(1).equals("CLOSE")) {
            this.dccData.closeChat(tokenizedString.getToken(2).substring(1, tokenizedString.getToken(2).length()));
        } else if (tokenizedString.getToken(1).equals("ACCEPT")) {
            ConnectDCC connectDCC = (ConnectDCC)this.dccData.getConnection(tokenizedString.getToken(3));
            if (connectDCC != null) {
                this.getCapabilities().getOutputCapabilities().fireSetStatus(hashMap, "RESUME_SUCCEEDED");
                connectDCC.connect();
            } else {
                this.getCapabilities().getOutputCapabilities().fireSetStatus(hashMap, "RESUME_FAILED");
            }
        } else if (tokenizedString.getToken(1).equals("RESUME")) {
            GenericDCC genericDCC = this.dccData.getConnection(tokenizedString.getToken(3));
            if (genericDCC != null && genericDCC.getImplementation().getTypeOfDCC() == 1) {
                Send send = (Send)genericDCC.getImplementation();
                if (send.resume(Long.parseLong(tokenizedString.getToken(4)))) {
                    this.getCapabilities().getOutputCapabilities().fireSetStatus(hashMap, "RESUME_REQUEST");
                    String string = "PRIVMSG " + hashMap.get("$nick") + " :" + '\u0001' + "DCC ACCEPT " + tokenizedString.getTokenFrom(2) + '\u0001';
                    this.getCapabilities().sendln(string);
                    genericDCC.connect();
                } else {
                    this.getCapabilities().getOutputCapabilities().fireSetStatus(hashMap, "RESUME_REQUEST_ERROR");
                }
            }
        } else if (tokenizedString.getToken(1).equals("SEND")) {
            boolean bl;
            int n = tokenizedString.getTotalTokens() - 6;
            int n2 = Integer.parseInt(tokenizedString.getToken(4 + n));
            String string = ClientUtils.longip(tokenizedString.getToken(3 + n));
            if (n2 < 1024) {
                return 1;
            }
            String string2 = tokenizedString.getToken(2);
            if (n > 0) {
                string2 = tokenizedString.getTokenRange(2, 2 + n);
            }
            string2 = new File(string2).getName();
            File file = new File(ClientState.getClientState().getString("dcc.saveto", ClientDefaults.dcc_saveto), string2);
            Receive receive = new Receive(hashMap.get("$nick").toString(), file, Long.parseLong(tokenizedString.getToken(5 + n)));
            ConnectDCC connectDCC = new ConnectDCC(string, n2);
            connectDCC.announceFramework(this.ircfw);
            connectDCC.setImplementation(receive);
            this.dccData.addConnection(n2 + "", connectDCC);
            boolean bl4 = ClientState.getClientState().getInteger("dcc.onsend", 0) == 0 && SendRequest.showDialog(this.getCapabilities().getGlobalCapabilities().getFrame(), connectDCC);
            boolean bl5 = bl = ClientState.getClientState().getInteger("dcc.onsend", 0) == 1;
            if (bl4 || bl) {
                this.handleReceive(receive, connectDCC, hashMap, tokenizedString);
            }
        }
        return 1;
    }

    private void handleReceive(Receive receive, ConnectDCC connectDCC, HashMap hashMap, TokenizedString tokenizedString) {
        File file = receive.getFile();
        if (file.exists()) {
            int n = DCCUtilities.DetermineResumeOption(this.getCapabilities(), connectDCC);
            switch (n) {
                case 0: {
                    if (file.length() < receive.getExpectedSize()) {
                        receive.pleaseResume();
                        String string = "PRIVMSG " + hashMap.get("$nick") + " :" + '\u0001' + "DCC RESUME " + tokenizedString.getToken(2) + " " + tokenizedString.getToken(4) + " " + file.length() + '\u0001';
                        this.getCapabilities().sendln(string);
                        this.getCapabilities().getOutputCapabilities().fireSetStatus(hashMap, "SEND_RESUME_REQUEST");
                        break;
                    }
                    receive.fireError("file already completed, no need to resume");
                    break;
                }
                case 1: {
                    boolean bl = SendRequest.showDialog(this.getCapabilities().getGlobalCapabilities().getFrame(), connectDCC);
                    if (!bl) break;
                    this.handleReceive(receive, connectDCC, hashMap, tokenizedString);
                    break;
                }
                case 2: {
                    connectDCC.connect();
                }
            }
        } else {
            connectDCC.connect();
        }
    }
}

