/*
 * Decompiled with CFR 0.152.
 */
package rero.client.dcc;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.WeakHashMap;
import rero.client.Feature;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.ircfw.InternalDataList;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;

public class LocalInfo
extends Feature
implements FrameworkConstants,
ClientStateListener {
    public static final String RESOLVE_FROM_SERVER = "Server Method";
    public static final String RESOLVE_AUTOMATIC = "Normal Method";
    protected static String localHost = null;
    protected static boolean resolveProcessed = false;
    protected static String resolveHost = null;

    public void setLocalHost(String string) {
        try {
            if (localHost == null) {
                resolveHost = localHost = InetAddress.getByName(string).getHostAddress();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("$data", localHost + " " + localHost);
                hashMap.put("$parms", localHost);
                this.getCapabilities().getOutputCapabilities().fireSetStatus(hashMap, "RESOLVED_LOCALINFO");
            }
        }
        catch (Exception exception) {
            localHost = null;
            resolveProcessed = false;
            resolveHost = null;
            exception.printStackTrace();
        }
    }

    public String localip() {
        if (localHost != null) {
            return localHost;
        }
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
            return localHost;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "127.0.0.1";
        }
    }

    public void storeDataStructures(WeakHashMap weakHashMap) {
        weakHashMap.put("localInfo", this);
    }

    public void init() {
        ClientState.getClientState().addClientStateListener("dcc.localinfo", this);
        this.processLocalInfoSettings();
    }

    public void processLocalInfoSettings() {
        if (localHost != null) {
            return;
        }
        if (ClientState.getClientState().getString("dcc.localinfo", RESOLVE_FROM_SERVER).equals(RESOLVE_AUTOMATIC)) {
            new Thread(new Runnable(){

                public void run() {
                    LocalInfo.this.localip();
                }
            }).start();
        } else if (ClientState.getClientState().getString("dcc.localinfo", RESOLVE_FROM_SERVER).equals(RESOLVE_FROM_SERVER)) {
            if (!resolveProcessed) {
                this.getCapabilities().addTemporaryListener(new ResolveLocalInfo());
            } else {
                localHost = resolveHost;
            }
        } else {
            localHost = ClientState.getClientState().getString("dcc.localinfo", "127.0.0.1");
        }
    }

    public void propertyChanged(String string, String string2) {
        localHost = null;
        this.processLocalInfoSettings();
    }

    protected class ResolveLocalInfo
    implements ChatListener,
    FrameworkConstants {
        protected String myhost;

        public ResolveLocalInfo() {
            if (LocalInfo.this.getCapabilities().isConnected()) {
                LocalInfo.this.getCapabilities().sendln("USERHOST " + ((InternalDataList)LocalInfo.this.getCapabilities().getDataStructure("clientInformation")).getMyNick());
            }
        }

        public int fireChatEvent(HashMap hashMap) {
            if (hashMap.get("$event").equals("302")) {
                this.myhost = hashMap.get("$address").toString();
                this.myhost = this.myhost.substring(this.myhost.indexOf(64) + 1, this.myhost.length());
                new Thread(new Runnable(){

                    public void run() {
                        LocalInfo.this.setLocalHost(ResolveLocalInfo.this.myhost);
                    }
                }).start();
                resolveProcessed = true;
                return 6;
            }
            if (hashMap.get("$event").equals("376")) {
                LocalInfo.this.getCapabilities().sendln("USERHOST " + ((InternalDataList)LocalInfo.this.getCapabilities().getDataStructure("clientInformation")).getMyNick());
            }
            return 1;
        }

        public boolean isChatEvent(String string, HashMap hashMap) {
            return string.equals("302") || string.equals("376");
        }
    }
}

