/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import rero.client.Feature;
import rero.client.user.UserHandler;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.dialogs.HelpWindow;
import rero.ircfw.InternalDataList;
import rero.util.ClientUtils;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class BuiltInOperators
extends Feature
implements Predicate,
Function,
Loadable {
    protected InternalDataList data;
    protected UserHandler commands;

    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        this.commands = (UserHandler)this.getCapabilities().getDataStructure("commands");
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        String[] stringArray = new String[]{"&call", "&mask", "&sendRaw", "&sendNotice", "&sendAction", "&sendMessage", "&sendReply", "&sendRequest", "&nickComplete", "&nickCompleteAll", "&echo", "&echoRaw", "&echoStatus", "&echoAll", "&setQuery", "&cycleQuery", "&processInput", "&openCommand", "&getSupportHints"};
        for (int i = 0; i < stringArray.length; ++i) {
            scriptInstance.getScriptEnvironment().getEnvironment().put(stringArray[i], this);
        }
        scriptInstance.getScriptEnvironment().getEnvironment().put("&say", new say());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getAliasList", new getAliasList());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&parseSet", new parseSet());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&fireEvent", new fireEvent());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&echoColumns", new echoColumns());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&echo")) {
            switch (stack.size()) {
                case 1: {
                    this.getCapabilities().getUserInterface().printActive(this.getString(stack));
                    break;
                }
                case 2: {
                    this.getCapabilities().getUserInterface().printNormal(this.getString(stack), this.getString(stack));
                    break;
                }
                case 3: {
                    int n = BridgeUtilities.getInt(stack);
                    this.getCapabilities().getOutputCapabilities().echoToTarget(this.getString(stack), this.getString(stack), n == 2);
                    break;
                }
            }
            return SleepUtils.getEmptyScalar();
        }
        if (string.equals("&openCommand") && stack.size() == 1) {
            try {
                Runtime.getRuntime().exec(ClientState.getClientState().getString("ui.openfiles", ClientDefaults.ui_openfiles) + " " + stack.pop().toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string.equals("&echoStatus") && stack.size() == 1) {
            this.getCapabilities().getUserInterface().printStatus(this.getString(stack));
        } else if (string.equals("&echoRaw") && stack.size() == 2) {
            this.getCapabilities().getUserInterface().printRaw(BridgeUtilities.getString(stack, ""), BridgeUtilities.getString(stack, ""));
        } else if (string.equals("&echoAll") && stack.size() == 1) {
            this.getCapabilities().getUserInterface().printAll(this.getString(stack));
        } else if (string.equals("&setQuery") && stack.size() == 1) {
            this.getCapabilities().getUserInterface().setQuery(this.getString(stack));
        } else if (string.equals("&cycleQuery")) {
            this.getCapabilities().getOutputCapabilities().cycleQuery();
        } else if (string.equals("&sendRaw") && stack.size() == 1) {
            this.getCapabilities().sendln(this.getString(stack));
        } else {
            if (string.equals("&mask") && stack.size() == 2) {
                return SleepUtils.getScalar(ClientUtils.mask(this.getString(stack), this.getInt(stack)));
            }
            if (string.equals("&call") && stack.size() == 1) {
                String string2 = this.getString(stack);
                if (string2.charAt(0) != '/') {
                    string2 = "/" + string2;
                }
                this.commands.processCommand(string2);
            } else if (string.equals("&call") && stack.size() == 2) {
                String string3 = this.getString(stack);
                if (string3.charAt(0) != '/') {
                    string3 = "/" + string3;
                }
                this.commands.processCommandBuiltIn(string3);
            } else if (string.equals("&processInput") && stack.size() == 1) {
                this.commands.processInput(this.getString(stack));
            } else {
                if (string.equals("&nickComplete") && stack.size() == 2) {
                    return SleepUtils.getScalar(this.data.nickComplete(this.getString(stack), this.getString(stack)));
                }
                if (string.equals("&nickCompleteAll") && stack.size() == 2) {
                    Scalar scalar = SleepUtils.getArrayScalar();
                    Iterator iterator = this.data.nickCompleteAll(this.getString(stack), this.getString(stack)).iterator();
                    while (iterator.hasNext()) {
                        scalar.getArray().push(SleepUtils.getScalar(iterator.next().toString()));
                    }
                    return scalar;
                }
                if (string.substring(1, 5).equals("send") && stack.size() >= 2) {
                    String string4 = this.getString(stack);
                    String string5 = this.getString(stack);
                    if (string.equals("&sendNotice")) {
                        this.getCapabilities().getChatCapabilities().sendNotice(string4, string5);
                    } else if (string.equals("&sendMessage")) {
                        this.getCapabilities().getChatCapabilities().sendMessage(string4, string5);
                    } else if (string.equals("&sendAction")) {
                        this.getCapabilities().getChatCapabilities().sendAction(string4, string5);
                    } else if (string.equals("&sendReply")) {
                        this.getCapabilities().getChatCapabilities().sendReply(string4, string5, this.getString(stack));
                    } else if (string.equals("&sendRequest")) {
                        this.getCapabilities().getChatCapabilities().sendRequest(string4, string5, this.getString(stack));
                    }
                    return SleepUtils.getEmptyScalar();
                }
            }
        }
        if (string.equals("&getSupportHints")) {
            return SleepUtils.getHashWrapper(this.data.getSupportInfo());
        }
        return SleepUtils.getEmptyScalar();
    }

    private String getString(Stack stack) {
        if (stack.isEmpty()) {
            return "";
        }
        return ((Object)((Scalar)stack.pop()).getValue()).toString();
    }

    private int getInt(Stack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        return ((Scalar)stack.pop()).getValue().intValue();
    }

    public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
        return false;
    }

    private class say
    implements Function {
        private say() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            BuiltInOperators.this.getCapabilities().getChatCapabilities().sendMessage(BuiltInOperators.this.getCapabilities().getUserInterface().getQuery(), stack.pop().toString());
            return SleepUtils.getEmptyScalar();
        }
    }

    private class fireEvent
    implements Function {
        private fireEvent() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            if (stack.size() == 1) {
                BuiltInOperators.this.getCapabilities().injectEvent(BridgeUtilities.getString(stack, ""));
            } else {
                String string2 = BridgeUtilities.getString(stack, "UNKNOWN_EVENT");
                Scalar scalar = BridgeUtilities.getScalar(stack);
                if (scalar.getHash() != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("$event", string2);
                    Iterator iterator = scalar.getHash().keys().scalarIterator();
                    while (iterator.hasNext()) {
                        Scalar scalar2 = (Scalar)iterator.next();
                        hashMap.put(scalar2.toString(), scalar.getHash().getAt(scalar2).toString());
                    }
                    BuiltInOperators.this.getCapabilities().dispatchEvent(hashMap);
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class parseSet
    implements Function {
        private parseSet() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "UNKNOWN_SET");
            if (!stack.isEmpty() && ((Scalar)stack.peek()).getHash() != null) {
                ScalarHash scalarHash = ((Scalar)stack.pop()).getHash();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                Iterator iterator = scalarHash.keys().scalarIterator();
                while (iterator.hasNext()) {
                    Scalar scalar = (Scalar)iterator.next();
                    hashMap.put(scalar.toString(), scalarHash.getAt(scalar).toString());
                }
                return SleepUtils.getScalar(BuiltInOperators.this.getCapabilities().getOutputCapabilities().parseSet(hashMap, string2));
            }
            String string3 = BridgeUtilities.getString(stack, "<unknown>");
            String string4 = BridgeUtilities.getString(stack, "");
            return SleepUtils.getScalar(BuiltInOperators.this.getCapabilities().getOutputCapabilities().parseSet(ClientUtils.getEventHashMap(string3, string4), string2));
        }
    }

    private class getAliasList
    implements Function {
        private getAliasList() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(HelpWindow.getBuiltInAliases());
            linkedList.addAll(BuiltInOperators.this.commands.getScriptedAliases());
            return SleepUtils.getArrayWrapper(linkedList);
        }
    }

    private class echoColumns
    implements Function {
        private echoColumns() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            String string3 = BridgeUtilities.getString(stack, "");
            double d = BridgeUtilities.getDouble(stack, 1.0);
            BuiltInOperators.this.getCapabilities().getUserInterface().printChunk(string2, string3.replace('\t', ' '), string3.split("\t"), d);
            return SleepUtils.getEmptyScalar();
        }
    }
}

