/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.ArrayList;
import java.util.Stack;
import rero.client.Feature;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class ChannelOperators
extends Feature
implements Predicate,
Function,
Loadable {
    protected InternalDataList data;

    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        String[] stringArray = new String[]{"ison", "isop", "ishalfop", "isvoice", "isnormal", "ismode", "hasmode", "&getUsers", "&getOps", "&getHalfOps", "&getVoiced", "&getNormal", "&getTopic", "&getKey", "&getMode", "&getLimit", "&getModeFor", "&getModeChars"};
        for (int i = 0; i < stringArray.length; ++i) {
            scriptInstance.getScriptEnvironment().getEnvironment().put(stringArray[i], this);
        }
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&getModeChars")) {
            String string2 = this.data.getPrefixInfo().getModes();
            char[] cArray = string2.toCharArray();
            ArrayList<String> arrayList = new ArrayList<String>(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                arrayList.add(String.valueOf(c));
            }
            return SleepUtils.getArrayWrapper(arrayList);
        }
        if (string.equals("&getModeFor")) {
            String string3 = BridgeUtilities.getString(stack, "");
            String string4 = BridgeUtilities.getString(stack, "");
            Channel channel = this.data.getChannel(string4);
            if (this.data.getUser(string3) == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(this.data.getPrefixInfo().toString(this.data.getUser(string3).getModeFor(channel)));
        }
        if (stack.size() != 1) {
            return SleepUtils.getEmptyScalar();
        }
        String string5 = ((Object)((Scalar)stack.pop()).getValue()).toString();
        Channel channel = this.data.getChannel(string5);
        if (channel == null) {
            return null;
        }
        if (string.equals("&getTopic")) {
            return SleepUtils.getScalar(channel.getTopic());
        }
        if (string.equals("&getMode")) {
            return SleepUtils.getScalar(channel.getMode().toString());
        }
        if (string.equals("&getKey")) {
            return SleepUtils.getScalar(channel.getKey());
        }
        if (string.equals("&getLimit")) {
            return SleepUtils.getScalar(channel.getLimit());
        }
        Stack stack2 = new Stack();
        Object var7_14 = null;
        if (string.equals("&getUsers")) {
            return SleepUtils.getArrayWrapper(channel.getAllUsers());
        }
        if (string.equals("&getOps")) {
            return SleepUtils.getArrayWrapper(this.data.getUsersWithMode(string5, 'o'));
        }
        if (string.equals("&getHalfOps")) {
            return SleepUtils.getArrayWrapper(this.data.getUsersWithMode(string5, 'h'));
        }
        if (string.equals("&getVoiced")) {
            return SleepUtils.getArrayWrapper(this.data.getUsersWithMode(string5, 'v'));
        }
        if (string.equals("&getNormal")) {
            return SleepUtils.getArrayWrapper(this.data.getUsersWithMode(string5, ' '));
        }
        return null;
    }

    public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
        if (stack.size() != 2) {
            return false;
        }
        String string2 = ((Object)((Scalar)stack.pop()).getValue()).toString();
        String string3 = ((Object)((Scalar)stack.pop()).getValue()).toString();
        if (this.data.getChannel(string2) == null) {
            return false;
        }
        if (string.equals("ismode")) {
            for (int i = 0; i < string3.length(); ++i) {
                if (this.data.getChannel(string2).getMode().isSet(string3.charAt(i))) continue;
                return false;
            }
            return true;
        }
        if (!this.data.isUser(string3)) {
            return false;
        }
        if (string.equals("ison")) {
            return this.data.isOn(this.data.getUser(string3), this.data.getChannel(string2));
        }
        int n = this.data.getUser(string3).getModeFor(this.data.getChannel(string2));
        if (string.equals("isop")) {
            return this.data.getPrefixInfo().isMode(n, 'o');
        }
        if (string.equals("ishalfop")) {
            return this.data.getPrefixInfo().isMode(n, 'h');
        }
        if (string.equals("isvoice")) {
            return this.data.getPrefixInfo().isMode(n, 'v');
        }
        if (string.equals("isnormal")) {
            return n == 0;
        }
        if (string.equals("hasmode")) {
            return n != 0;
        }
        return false;
    }
}

