/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.Iterator;
import java.util.Stack;
import rero.client.Feature;
import rero.config.ClientState;
import rero.config.StringList;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class ConfigOperators
extends Feature
implements Loadable {
    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getProperty", new getProperty());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getPropertyList", new getPropertyList());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&setProperty", new setProperty());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&setPropertyList", new setPropertyList());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&baseDirectory", new getBaseDirectory());
        scriptInstance.getScriptEnvironment().getEnvironment().put("-isSetT", new isSet1());
        scriptInstance.getScriptEnvironment().getEnvironment().put("-isSetF", new isSet2());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    private static class getBaseDirectory
    implements Function {
        private getBaseDirectory() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            ClientState.getClientState();
            return SleepUtils.getScalar(ClientState.getBaseDirectory().getAbsolutePath());
        }
    }

    private static class isSet2
    implements Predicate {
        private isSet2() {
        }

        public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            return ClientState.getClientState().isOption(string2, false);
        }
    }

    private static class isSet1
    implements Predicate {
        private isSet1() {
        }

        public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            return ClientState.getClientState().isOption(string2, true);
        }
    }

    private static class setProperty
    implements Function {
        private setProperty() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            String string3 = stack.pop().toString();
            ClientState.getClientState().setString(string2, string3);
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class getProperty
    implements Function {
        private getProperty() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            String string3 = "";
            if (!stack.isEmpty()) {
                string3 = stack.pop().toString();
            }
            return SleepUtils.getScalar(ClientState.getClientState().getString(string2, string3));
        }
    }

    private static class setPropertyList
    implements Function {
        private setPropertyList() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            Scalar scalar = (Scalar)stack.pop();
            StringList stringList = ClientState.getClientState().getStringList(string2);
            stringList.clear();
            Iterator iterator = scalar.getArray().scalarIterator();
            while (iterator.hasNext()) {
                stringList.add(iterator.next().toString());
            }
            stringList.save();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class getPropertyList
    implements Function {
        private getPropertyList() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            Scalar scalar = SleepUtils.getArrayScalar();
            Iterator iterator = ClientState.getClientState().getStringList(string2).getList().iterator();
            while (iterator.hasNext()) {
                scalar.getArray().push(SleepUtils.getScalar(iterator.next().toString()));
            }
            return scalar;
        }
    }
}

