/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.Stack;
import rero.client.Feature;
import rero.dialogs.server.Server;
import rero.dialogs.server.ServerData;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class ServerOperators
extends Feature
implements Loadable {
    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getAllServers", new getAllServers());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getAllNetworks", new getAllNetworks());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getServerInfo", new getServerInfo());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getServersForNetwork", new getServersForNetwork());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&serverInfoHost", new serverInfoHost());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&serverInfoPortRange", new serverInfoPorts());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&serverInfoNetwork", new serverInfoNetwork());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&serverInfoIsSecure", new serverInfoIsSecure());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&serverInfoPassword", new serverInfoPassword());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&serverInfoDescription", new serverInfoDescription());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&serverInfoConnectPort", new serverInfoConnectPort());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&serverInfoCommand", new serverInfoCommand());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    private static class serverInfoIsSecure
    implements Function {
        private serverInfoIsSecure() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Server server = Server.decode(BridgeUtilities.getString(stack, ""));
            if (server == null) {
                return SleepUtils.getEmptyScalar();
            }
            if (server.isSecure()) {
                return SleepUtils.getScalar(1);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class serverInfoNetwork
    implements Function {
        private serverInfoNetwork() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Server server = Server.decode(BridgeUtilities.getString(stack, ""));
            if (server == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(server.getNetwork());
        }
    }

    private static class serverInfoPorts
    implements Function {
        private serverInfoPorts() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Server server = Server.decode(BridgeUtilities.getString(stack, ""));
            if (server == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(server.getPorts());
        }
    }

    private static class serverInfoHost
    implements Function {
        private serverInfoHost() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Server server = Server.decode(BridgeUtilities.getString(stack, ""));
            if (server == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(server.getHost());
        }
    }

    private static class serverInfoCommand
    implements Function {
        private serverInfoCommand() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Server server = Server.decode(BridgeUtilities.getString(stack, ""));
            if (server == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(server.getCommand());
        }
    }

    private static class serverInfoConnectPort
    implements Function {
        private serverInfoConnectPort() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Server server = Server.decode(BridgeUtilities.getString(stack, ""));
            if (server == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(server.getConnectPort());
        }
    }

    private static class serverInfoDescription
    implements Function {
        private serverInfoDescription() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Server server = Server.decode(BridgeUtilities.getString(stack, ""));
            if (server == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(server.getDescription());
        }
    }

    private static class serverInfoPassword
    implements Function {
        private serverInfoPassword() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Server server = Server.decode(BridgeUtilities.getString(stack, ""));
            if (server == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(server.getPassword());
        }
    }

    private static class getServersForNetwork
    implements Function {
        private getServersForNetwork() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            if (string2 == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getArrayWrapper(ServerData.getServerData().getGroup(string2).getServers());
        }
    }

    private static class getServerInfo
    implements Function {
        private getServerInfo() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            if (string2 == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(ServerData.getServerData().getServerByName(string2).toString());
        }
    }

    private static class getAllNetworks
    implements Function {
        private getAllNetworks() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getArrayWrapper(ServerData.getServerData().getGroups());
        }
    }

    private static class getAllServers
    implements Function {
        private getAllServers() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getArrayWrapper(ServerData.getServerData().getAllServers());
        }
    }
}

