/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.util.Stack;
import rero.client.Feature;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class SoundOperators
extends Feature
implements Loadable {
    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        scriptInstance.getScriptEnvironment().getEnvironment().put("&loadSound", new loadSound());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&soundPlay", new soundPlay());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&soundLoop", new soundLoop());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&soundStop", new soundStop());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    private static class soundStop
    implements Function {
        private soundStop() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            AudioClip audioClip = (AudioClip)BridgeUtilities.getObject(stack);
            audioClip.stop();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class soundLoop
    implements Function {
        private soundLoop() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            AudioClip audioClip = (AudioClip)BridgeUtilities.getObject(stack);
            audioClip.loop();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class soundPlay
    implements Function {
        private soundPlay() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            AudioClip audioClip = (AudioClip)BridgeUtilities.getObject(stack);
            audioClip.play();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class loadSound
    implements Function {
        private loadSound() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, null);
            if (string2 != null && new File(string2).exists()) {
                try {
                    AudioClip audioClip = Applet.newAudioClip(new File(string2).toURL());
                    return SleepUtils.getScalar(audioClip);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

