/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.Stack;
import rero.client.Feature;
import rero.util.TimerListener;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class TimerOperators
extends Feature
implements Loadable {
    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        scriptInstance.getScriptEnvironment().getEnvironment().put("&addTimer", new addTimer());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&stopTimer", new stopTimer());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&setTimerResolution", new setResolution());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    private static class ScriptedTimer
    implements TimerListener {
        protected ScriptInstance si;
        protected SleepClosure func;
        protected Scalar args;

        public ScriptedTimer(SleepClosure sleepClosure, ScriptInstance scriptInstance, Scalar scalar) {
            this.func = sleepClosure;
            this.si = scriptInstance;
            this.args = scalar;
        }

        public void timerExecute() {
            if (this.si == null || !this.si.isLoaded()) {
                this.args = null;
                this.si = null;
                this.func = null;
                return;
            }
            Stack<Scalar> stack = new Stack<Scalar>();
            if (this.args != null) {
                stack.push(this.args);
            }
            this.func.callClosure("timer", this.si, stack);
        }
    }

    private class setResolution
    implements Function {
        private setResolution() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            TimerOperators.this.getCapabilities().getTimer().setResolution(BridgeUtilities.getInt(stack));
            return SleepUtils.getEmptyScalar();
        }
    }

    private class stopTimer
    implements Function {
        private stopTimer() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            ScriptedTimer scriptedTimer = (ScriptedTimer)BridgeUtilities.getObject(stack);
            TimerOperators.this.getCapabilities().getTimer().stopTimer(scriptedTimer);
            return SleepUtils.getEmptyScalar();
        }
    }

    private class addTimer
    implements Function {
        private addTimer() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            int n = -1;
            SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
            int n2 = BridgeUtilities.getInt(stack);
            if (!stack.isEmpty()) {
                n = BridgeUtilities.getInt(stack);
            }
            ScriptedTimer scriptedTimer = !stack.isEmpty() ? new ScriptedTimer(sleepClosure, scriptInstance, BridgeUtilities.getScalar(stack)) : new ScriptedTimer(sleepClosure, scriptInstance, null);
            TimerOperators.this.getCapabilities().getTimer().addTimer(scriptedTimer, n2, n);
            return SleepUtils.getScalar(scriptedTimer);
        }
    }
}

