/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import rero.client.Feature;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import rero.ircfw.User;
import rero.util.StringUtils;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class UserOperators
extends Feature
implements Predicate,
Function,
Loadable {
    protected InternalDataList data;

    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        String[] stringArray = new String[]{"&searchAddressList", "&getChannels", "&getAddress", "&getIdleTime", "-isidle"};
        for (int i = 0; i < stringArray.length; ++i) {
            scriptInstance.getScriptEnvironment().getEnvironment().put(stringArray[i], this);
        }
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        Object object;
        User user = null;
        if (string.equals("&searchAddressList")) {
            if (stack.size() != 1) {
                return null;
            }
            String string2 = ((Object)((Scalar)stack.pop()).getValue()).toString();
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = this.data.getAllUsers().iterator();
            while (iterator.hasNext()) {
                User user2 = (User)iterator.next();
                if (!StringUtils.iswm(string2, user2.getFullAddress())) continue;
                hashSet.add(user2.getNick());
            }
            return SleepUtils.getArrayWrapper(hashSet);
        }
        if (stack.size() != 1) {
            user = this.data.getMyUser();
        } else {
            object = ((Object)((Scalar)stack.pop()).getValue()).toString();
            if (this.data.isUser((String)object)) {
                user = this.data.getUser((String)object);
            } else {
                return SleepUtils.getEmptyScalar();
            }
        }
        if (string.equals("&getChannels")) {
            object = new HashSet();
            Iterator iterator = user.getChannels().iterator();
            while (iterator.hasNext()) {
                object.add(((Channel)iterator.next()).getName());
            }
            return SleepUtils.getArrayWrapper((Collection)object);
        }
        if (string.equals("&getAddress")) {
            return SleepUtils.getScalar(user.getAddress());
        }
        if (string.equals("&getIdleTime")) {
            return SleepUtils.getScalar(user.getIdleTime());
        }
        return null;
    }

    public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
        if (stack.size() != 1) {
            return false;
        }
        String string2 = ((Object)((Scalar)stack.pop()).getValue()).toString();
        if (string.equals("-isidle") && this.data.isUser(string2)) {
            return this.data.getUser(string2).getIdleTime() > 300;
        }
        return false;
    }
}

