/*
 * Decompiled with CFR 0.152.
 */
package rero.client.notify;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import rero.client.Feature;
import rero.client.notify.Lag;
import rero.client.notify.NotifyUser;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.config.StringList;
import rero.ircfw.interfaces.ChatListener;
import rero.util.TimerListener;
import rero.util.TokenizedString;

public class NotifyData
extends Feature
implements ChatListener,
TimerListener,
ClientStateListener {
    protected HashMap users = new HashMap();
    protected Set signedon = new HashSet();
    protected Lag lag = new Lag();
    protected int isChecking = 0;

    public void reset() {
        this.signedon = new HashSet();
    }

    public void propertyChanged(String string, String string2) {
        this.hashUsers();
    }

    public void hashUsers() {
        HashMap hashMap = new HashMap();
        Iterator iterator = ClientState.getClientState().getStringList("notify.users").getList().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.users.containsKey(string)) {
                hashMap.put(string, this.users.get(string));
                continue;
            }
            hashMap.put(string, this.createNotifyUser(string));
        }
        this.users = hashMap;
    }

    public void addUser(String string) {
        StringList stringList = ClientState.getClientState().getStringList("notify.users");
        stringList.add(string);
        stringList.save();
        ClientState.getClientState().sync();
    }

    public void removeUser(String string) {
        StringList stringList = ClientState.getClientState().getStringList("notify.users");
        stringList.remove(string);
        stringList.save();
        ClientState.getClientState().sync();
    }

    public Set getSignedOnUsers() {
        HashSet<NotifyUser> hashSet = new HashSet<NotifyUser>();
        Iterator iterator = this.users.values().iterator();
        while (iterator.hasNext()) {
            NotifyUser notifyUser = (NotifyUser)iterator.next();
            if (!notifyUser.isSignedOn()) continue;
            hashSet.add(notifyUser);
        }
        return hashSet;
    }

    public Set getNotifyUsers() {
        return new HashSet(this.users.values());
    }

    public Set getSignedOffUsers() {
        HashSet<NotifyUser> hashSet = new HashSet<NotifyUser>();
        Iterator iterator = this.users.values().iterator();
        while (iterator.hasNext()) {
            NotifyUser notifyUser = (NotifyUser)iterator.next();
            if (notifyUser.isSignedOn()) continue;
            hashSet.add(notifyUser);
        }
        return hashSet;
    }

    public void init() {
        this.hashUsers();
        this.getCapabilities().addChatListener(this);
        this.getCapabilities().getTimer().addTimer(this, 60000L);
        ClientState.getClientState().addClientStateListener("notify.users", this);
    }

    public void cleanup() {
        this.getCapabilities().getTimer().stopTimer(this);
    }

    public void storeDataStructures(WeakHashMap weakHashMap) {
        weakHashMap.put("lag", this.lag);
        weakHashMap.put("notify", this);
    }

    public NotifyUser createNotifyUser(String string) {
        NotifyUser notifyUser = new NotifyUser(string);
        notifyUser.installCapabilities(this.getCapabilities());
        return notifyUser;
    }

    public NotifyUser getUserInfo(String string) {
        return (NotifyUser)this.users.get(string);
    }

    public void checkNotify() {
        if (this.getCapabilities().isConnected()) {
            ++this.isChecking;
            StringBuffer stringBuffer = new StringBuffer("ISON :");
            Iterator iterator = this.users.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                stringBuffer.append(" ");
            }
            this.lag.checkLag();
            this.getCapabilities().sendln(stringBuffer.toString());
        }
    }

    public void timerExecute() {
        this.checkNotify();
    }

    public int fireChatEvent(HashMap hashMap) {
        if (hashMap.get("$event").equals("376")) {
            this.checkNotify();
            return 1;
        }
        this.lag.setLag();
        if (hashMap.get("$event").equals("303")) {
            NotifyUser notifyUser;
            String string = (String)hashMap.get("$parms");
            TokenizedString tokenizedString = new TokenizedString(string);
            tokenizedString.tokenize(" ");
            HashSet<NotifyUser> hashSet = new HashSet<NotifyUser>();
            for (int i = 0; i < tokenizedString.getTotalTokens(); ++i) {
                notifyUser = this.getUserInfo(tokenizedString.getToken(i));
                if (notifyUser != null && !notifyUser.isSignedOn()) {
                    notifyUser.signOn();
                }
                hashSet.add(notifyUser);
            }
            this.signedon.removeAll(hashSet);
            Iterator iterator = this.signedon.iterator();
            while (iterator.hasNext()) {
                notifyUser = (NotifyUser)iterator.next();
                if (notifyUser == null || !notifyUser.isSignedOn() || !this.users.containsKey(notifyUser.toString())) continue;
                notifyUser.signOff();
            }
            this.signedon = hashSet;
        }
        --this.isChecking;
        return 2;
    }

    public boolean isChatEvent(String string, HashMap hashMap) {
        return this.isChecking > 0 && (string.equals("303") || string.equals("461")) || string.equals("376");
    }
}

