/*
 * Decompiled with CFR 0.152.
 */
package rero.client.notify;

import java.util.HashMap;
import rero.client.Feature;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;

public class NotifyUser
extends Feature
implements ChatListener,
FrameworkConstants {
    protected String nickname;
    protected String address;
    protected long time;
    protected boolean signedon;

    public void signOff() {
        this.signedon = false;
        this.time = System.currentTimeMillis();
        this.getCapabilities().injectEvent(":" + this.nickname + "!" + this.address + " SIGNOFF :signed off");
    }

    public void signOn() {
        this.getCapabilities().addTemporaryListener(this);
        this.getCapabilities().sendln("USERHOST " + this.nickname);
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isSignedOn() {
        return this.signedon;
    }

    public long getTimeOnline() {
        return (System.currentTimeMillis() - this.time) / 1000L;
    }

    public NotifyUser(String string) {
        this.nickname = string;
        this.signedon = false;
    }

    public void init() {
    }

    public int fireChatEvent(HashMap hashMap) {
        this.address = (String)hashMap.get("$address");
        this.signedon = true;
        this.time = System.currentTimeMillis();
        this.getCapabilities().injectEvent(":" + this.nickname + "!" + this.address + " SIGNON :signed on");
        return 6;
    }

    public boolean isChatEvent(String string, HashMap hashMap) {
        if (string.equals("302")) {
            String string2 = (String)hashMap.get("$nick");
            return string2.equals(this.nickname);
        }
        return false;
    }

    public String toString() {
        return this.nickname;
    }
}

