/*
 * Decompiled with CFR 0.152.
 */
package rero.client.server;

import java.util.HashMap;
import java.util.Iterator;
import rero.client.Feature;
import rero.client.notify.NotifyData;
import rero.client.server.IgnoreHandler;
import rero.config.ClientState;
import rero.ident.IdentDaemon;
import rero.ident.IdentListener;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import rero.ircfw.User;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.net.SocketConnection;
import rero.net.SocketEvent;
import rero.net.interfaces.SocketStatusListener;
import rero.test.QuickConnect;
import rero.util.ClientUtils;

public class ServerHandler
extends Feature
implements FrameworkConstants,
SocketStatusListener,
ChatListener,
IdentListener {
    protected NotifyData notify;
    protected InternalDataList data;
    protected SocketConnection socket;
    protected User restoreInformation = null;
    protected String restoreServer;
    protected IgnoreHandler ignoreHandler;
    protected NickInUseListener nickListener = null;

    public void init() {
        this.getCapabilities().getChatFramework().getProtocolDispatcher().setInternalListener(this);
        this.getCapabilities().getSocketConnection().addSocketStatusListener(this);
        this.socket = this.getCapabilities().getSocketConnection();
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        this.notify = (NotifyData)this.getCapabilities().getDataStructure("notify");
        this.ignoreHandler = new IgnoreHandler();
        IdentDaemon.getIdentDaemon().addIdentListener(this);
    }

    public void identRequest(String string, String string2) {
        this.getCapabilities().getOutputCapabilities().fireSetStatus(ClientUtils.getEventHashMap(string, string2), "IDENT_REQUEST");
    }

    public void cleanup() {
        this.data.reset();
        this.notify.reset();
        this.data.setMyNick("<Unknown>");
        this.restoreInformation = null;
    }

    public int fireChatEvent(HashMap hashMap) {
        String string = (String)hashMap.get("$event");
        if (string.equals("376")) {
            if (this.restoreInformation != null) {
                Iterator iterator = this.restoreInformation.getChannels().iterator();
                while (iterator.hasNext()) {
                    Channel channel = (Channel)iterator.next();
                    this.getCapabilities().sendln("JOIN " + channel.getName() + " :" + channel.getKey());
                }
                this.restoreInformation = null;
            }
            return 1;
        }
        if (string.equals("PING")) {
            this.getCapabilities().sendln("PONG :" + hashMap.get("$parms"));
            return 2;
        }
        if (this.ignoreHandler.isIgnore((String)hashMap.get("$nick"), (String)hashMap.get("$address"))) {
            return 2;
        }
        return 1;
    }

    public boolean isChatEvent(String string, HashMap hashMap) {
        if (this.ignoreHandler.isCheckingIgnore() && (string.equals("NOTICE") || string.equals("PRIVMSG") || string.equals("REPLY") || string.equals("REQUEST") || string.equals("ACTION"))) {
            return true;
        }
        if (string.equals("376")) {
            return true;
        }
        return string.equals("PING");
    }

    public void socketStatusChanged(SocketEvent socketEvent) {
        if (socketEvent.data.isConnected) {
            String string;
            String string2;
            this.getCapabilities().getOutputCapabilities().fireSetStatus(ClientUtils.getEventHashMap(socketEvent.data.hostname, "connected"), "IRC_CONNECT");
            String[] stringArray = ClientState.getClientState().getString("user.email", "jircii@127.0.0.1").split("@");
            if (stringArray.length == 1 && (stringArray = new String[]{stringArray[0], "127.0.0.1"})[0].length() == 0) {
                stringArray[0] = "jircii";
            }
            if (socketEvent.data.password != null) {
                this.getCapabilities().sendln("PASS " + socketEvent.data.password);
            }
            if (QuickConnect.IsQuickConnect()) {
                string2 = ClientState.getClientState().getString("user.rname", "jIRCii Web User: http://jircii.hick.org/");
                string = ClientState.getClientState().getString("user.nick", QuickConnect.GetInformation().getNickname());
            } else if (System.currentTimeMillis() % 5L == 0L) {
                string2 = ClientState.getClientState().getString("user.rname", "I'm to lame to read mIRC.hlp");
                string = ClientState.getClientState().getString("user.nick", "madgoat");
            } else {
                string2 = ClientState.getClientState().getString("user.rname", ClientUtils.tagline());
                string = ClientState.getClientState().getString("user.nick", "IRCFrEAK");
            }
            if (this.restoreInformation != null) {
                string = this.restoreInformation.getNick();
            }
            this.getCapabilities().sendln("USER " + stringArray[0] + " " + stringArray[1] + " " + stringArray[1] + " :" + string2);
            this.getCapabilities().sendln("NICK " + string);
            if (this.nickListener == null || !this.nickListener.isArmed()) {
                this.nickListener = new NickInUseListener();
                this.getCapabilities().addTemporaryListener(this.nickListener);
            }
        } else {
            boolean bl = false;
            this.getCapabilities().getOutputCapabilities().fireSetAll(ClientUtils.getEventHashMap(socketEvent.data.hostname, socketEvent.message), "IRC_DISCONNECT");
            if (this.data.getMyUser().getChannels().size() > 0 && ClientState.getClientState().isOption("option.reconnect", true)) {
                System.out.println("Reconnecting is an option");
                this.restoreInformation = this.data.getMyUser().copy();
                this.restoreServer = socketEvent.data.hostname;
                this.getCapabilities().getOutputCapabilities().fireSetAll(ClientUtils.getEventHashMap(socketEvent.data.hostname, socketEvent.message), "IRC_RECONNECT");
                this.getCapabilities().getGlobalCapabilities().setTabTitle(this.getCapabilities(), "reconnecting");
                this.socket.connect(socketEvent.data.hostname, socketEvent.data.port, ClientState.getClientState().getInteger("reconnect.time", 5) * 1000, socketEvent.data.password, socketEvent.data.isSecure);
                bl = true;
            }
            this.data.reset();
            this.notify.reset();
            this.data.setMyNick("<Unknown>");
            if (this.restoreInformation != null && !bl) {
                this.getCapabilities().getOutputCapabilities().fireSetStatus(ClientUtils.getEventHashMap(socketEvent.data.hostname, socketEvent.message), "IRC_RECONNECT");
                this.getCapabilities().getGlobalCapabilities().setTabTitle(this.getCapabilities(), "reconnecting");
                this.socket.connect(socketEvent.data.hostname, socketEvent.data.port, ClientState.getClientState().getInteger("reconnect.time", 5) * 1000, socketEvent.data.password, socketEvent.data.isSecure);
            }
        }
    }

    protected class NickInUseListener
    implements ChatListener {
        protected String altNick = ClientState.getClientState().getString("user.altnick", "lamer" + System.currentTimeMillis());
        protected boolean armed = true;

        protected NickInUseListener() {
        }

        public boolean isChatEvent(String string, HashMap hashMap) {
            return string.equals("001") || string.equals("433");
        }

        public boolean isArmed() {
            return this.armed;
        }

        public int fireChatEvent(HashMap hashMap) {
            String string = (String)hashMap.get("$event");
            if (string.equals("433")) {
                if (QuickConnect.IsQuickConnect() && QuickConnect.GetInformation().getURL().getUserInfo() != null) {
                    this.altNick = ClientState.getClientState().getString("user.nick", QuickConnect.GetInformation().getNickname()) + System.currentTimeMillis();
                }
                ServerHandler.this.getCapabilities().sendln("NICK " + this.altNick);
            }
            this.armed = false;
            return 5;
        }
    }
}

