/*
 * Decompiled with CFR 0.152.
 */
package rero.client.user;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import rero.bridges.alias.AliasEnvironment;
import rero.bridges.alias.ScriptAlias;
import rero.client.Feature;
import rero.client.user.BuiltInCommands;
import rero.client.user.ClientCommand;
import rero.gui.input.InputListener;
import rero.gui.input.UserInputEvent;
import rero.ircfw.InternalDataList;
import rero.util.ClientUtils;
import rero.util.StringParser;

public class UserHandler
extends Feature
implements InputListener {
    protected static Pattern commandParametersPattern = Pattern.compile("/(\\w*)\\s(.*)");
    protected AliasEnvironment scriptedAliases;
    protected HashMap commands = new HashMap();
    protected BuiltInCommands builtInCommands = new BuiltInCommands();
    protected InternalDataList ircData;

    public Collection getScriptedAliases() {
        return this.scriptedAliases.getAliasList();
    }

    public void storeDataStructures(WeakHashMap weakHashMap) {
        weakHashMap.put("commands", this);
    }

    public void init() {
        this.scriptedAliases = (AliasEnvironment)this.getCapabilities().getDataStructure("aliasBridge");
        this.ircData = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        LinkedList linkedList = new LinkedList();
        this.getCapabilities().setupFeature(this.builtInCommands, linkedList);
        this.getCapabilities().finalizeFeatures(linkedList);
    }

    public boolean isNickComplete(String string) {
        int n = string.indexOf(58);
        return n > -1 && n == string.indexOf(32) - 1 && ClientUtils.isChannel(this.getQuery());
    }

    public void processNickCompletion(String string) {
        String string2 = string.substring(0, string.indexOf(58));
        string = string.substring(string2.length() + 1, string.length());
        this.getCapabilities().getChatCapabilities().sendMessage(this.getQuery(), this.ircData.nickComplete(string2, this.getQuery()) + ":" + string);
    }

    public String getQuery() {
        return this.getCapabilities().getUserInterface().getQuery();
    }

    public void onInput(UserInputEvent userInputEvent) {
        if (this.ircData.getMyUser() != null) {
            boolean bl = this.ircData.getMyUser().isIdle();
            this.ircData.getMyUser().touch();
            if (bl) {
                this.getCapabilities().getUserInterface().notifyWindow(this.getQuery());
            }
        }
        if (!userInputEvent.isConsumed() && userInputEvent.text.length() > 0) {
            this.processInput(userInputEvent.text);
        }
    }

    public void processInput(String string) {
        if (string.charAt(0) == '/') {
            this.processCommand(string);
        } else if (this.isNickComplete(string)) {
            this.processNickCompletion(string);
        } else if (this.getQuery().length() > 0 && (this.getCapabilities().isConnected() || this.getQuery().charAt(0) == '=')) {
            this.getCapabilities().getChatCapabilities().sendMessage(this.getQuery(), string);
        }
    }

    public void registerCommand(String string, ClientCommand clientCommand) {
        this.commands.put(string, clientCommand);
    }

    public void runAlias(String string, String string2) {
        if (this.scriptedAliases.isAlias(string = string.toUpperCase())) {
            ScriptAlias scriptAlias = this.scriptedAliases.getAlias(string);
            scriptAlias.runAlias(string, string2);
            return;
        }
        this.runAliasBuiltIn(string, string2);
    }

    public void runAliasBuiltIn(String string, String string2) {
        if (this.commands.get(string) != null) {
            ClientCommand clientCommand = (ClientCommand)this.commands.get(string);
            clientCommand.runAlias(string, string2);
            return;
        }
        this.builtInCommands.runAlias(string, string2);
    }

    public void processCommand(String string) {
        String string2;
        String string3;
        StringParser stringParser = new StringParser(string = string.trim(), commandParametersPattern);
        if (stringParser.matches()) {
            string3 = stringParser.getParsedString(0);
            string2 = stringParser.getParsedString(1);
        } else {
            string3 = string.substring(1, string.length());
            string2 = "";
        }
        this.runAlias(string3, string2);
    }

    public void processCommandBuiltIn(String string) {
        String string2;
        String string3;
        StringParser stringParser = new StringParser(string = string.trim(), commandParametersPattern);
        if (stringParser.matches()) {
            string3 = stringParser.getParsedString(0);
            string2 = stringParser.getParsedString(1);
        } else {
            string3 = string.substring(1, string.length());
            string2 = "";
        }
        this.runAliasBuiltIn(string3, string2);
    }
}

