/*
 * Decompiled with CFR 0.152.
 */
package rero.dcc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rero.dcc.GenericDCC;
import rero.dcc.ProtocolDCC;

public class DataDCC {
    protected static List dccList;
    protected static HashMap resumeData;
    protected HashMap connectionCache = new HashMap();

    public DataDCC() {
        if (dccList == null) {
            dccList = Collections.synchronizedList(new LinkedList());
        }
        if (resumeData == null) {
            resumeData = new HashMap();
        }
    }

    public void addConnection(String string, GenericDCC genericDCC) {
        dccList.add(genericDCC);
        resumeData.put(string, genericDCC);
    }

    public LinkedList getConnections(int n, int n2) {
        return this.getConnections(dccList, n, n2);
    }

    public LinkedList getConnections(Collection collection, int n, int n2) {
        LinkedList<GenericDCC> linkedList = new LinkedList<GenericDCC>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            GenericDCC genericDCC = (GenericDCC)iterator.next();
            if (n != -1 && genericDCC.getTypeOfDCC() != n || n2 != -1 && genericDCC.getState() != n2) continue;
            linkedList.add(genericDCC);
        }
        return linkedList;
    }

    public List getAllConnections() {
        return dccList;
    }

    public GenericDCC getConnectionFromHash(String string) {
        Iterator iterator = this.getAllConnections().iterator();
        while (iterator.hasNext()) {
            GenericDCC genericDCC = (GenericDCC)iterator.next();
            if (!genericDCC.getImplementation().toString().equals(string)) continue;
            return genericDCC;
        }
        return null;
    }

    public Iterator getActiveConnections() {
        return this.getConnections(-1, 402).iterator();
    }

    public Iterator getWaitingConnections() {
        return this.getConnections(-1, 401).iterator();
    }

    public Iterator getClosedConnections() {
        return this.getConnections(-1, 403).iterator();
    }

    public GenericDCC getUserConnection(Collection collection, String string) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            GenericDCC genericDCC = (GenericDCC)iterator.next();
            if (!genericDCC.getNickname().equals(string)) continue;
            return genericDCC;
        }
        return null;
    }

    public GenericDCC getConnection(String string) {
        return (GenericDCC)resumeData.get(string);
    }

    public GenericDCC getConnectionToAccept(String string) {
        return this.getUserConnection(this.getConnections(-1, 401), string);
    }

    public void closeConnection(String string) {
        this.closeConnection(string, -1);
    }

    public void closeConnection(String string, int n) {
        GenericDCC genericDCC = this.getUserConnection(this.getConnections(n, 402), string);
        if (genericDCC != null) {
            genericDCC.getImplementation().close();
        }
    }

    public void closeChat(String string) {
        ProtocolDCC protocolDCC = this.getSpecificConnection(string, 3);
        if (protocolDCC != null) {
            protocolDCC.close();
        }
    }

    public void removeConnection(GenericDCC genericDCC) {
        dccList.remove(genericDCC.getImplementation());
        this.connectionCache.remove(genericDCC.getNickname());
    }

    public ProtocolDCC getSpecificConnection(String string, int n) {
        Object object;
        if (this.connectionCache.containsKey(string)) {
            object = (ProtocolDCC)this.connectionCache.get(string);
            if (((ProtocolDCC)object).getState() == 402 && ((ProtocolDCC)object).getTypeOfDCC() == n) {
                return object;
            }
            this.connectionCache.remove(string);
        }
        object = this.getActiveConnections();
        while (object.hasNext()) {
            ProtocolDCC protocolDCC = ((GenericDCC)object.next()).getImplementation();
            if (protocolDCC.getTypeOfDCC() != n || !protocolDCC.getNickname().equals(string)) continue;
            this.connectionCache.put(string, protocolDCC);
            return protocolDCC;
        }
        return null;
    }
}

