/*
 * Decompiled with CFR 0.152.
 */
package rero.dcc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import rero.dcc.ProtocolDCC;

public class Receive
extends ProtocolDCC {
    protected static int PACKET_SIZE = 4096;
    protected File dumpTo;
    protected FileOutputStream fileStream;
    protected long receivedSize;
    protected long finalSize;
    protected long startSize;

    public Receive(String string, File file, long l) {
        this.nickname = string;
        this.dumpTo = file;
        this.finalSize = l;
        this.receivedSize = 0L;
        this.startSize = 0L;
    }

    public long getBytesReceived() {
        return this.receivedSize;
    }

    public long getExpectedSize() {
        return this.finalSize;
    }

    public File getFile() {
        return this.dumpTo;
    }

    public long getTimeRemaining() {
        long l = this.getExpectedSize() - this.getFile().length();
        long l2 = this.getTransferRate();
        if (l2 == 0L) {
            l2 = 1000L;
        }
        return l / l2;
    }

    public void setFile(File file) {
        this.dumpTo = file;
    }

    public void pleaseResume() {
        this.receivedSize = this.dumpTo.length();
        this.startSize = this.dumpTo.length();
    }

    public long getStartOffset() {
        return this.startSize;
    }

    public int getTransferRate() {
        if (this.getTotalTime() < 1000L) {
            return 1000;
        }
        return (int)((this.getBytesReceived() - this.getStartOffset()) / (this.getTotalTime() / 1000L));
    }

    public int getTypeOfDCC() {
        return 2;
    }

    public void run() {
        Exception exception;
        block13: {
            if (this.socket == null || !this.socket.isConnected()) {
                return;
            }
            try {
                this.socket.setSoTimeout(120000);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            this.fireEvent("RECEIVE_START", null);
            this.startTime = System.currentTimeMillis();
            InputStream inputStream = null;
            OutputStream outputStream = null;
            byte[] byArray = new byte[PACKET_SIZE];
            byte[] byArray2 = new byte[4];
            exception = null;
            try {
                boolean bl;
                boolean bl2 = bl = this.startSize != 0L;
                if (!this.dumpTo.getParentFile().exists()) {
                    this.dumpTo.getParentFile().mkdirs();
                }
                this.fileStream = new FileOutputStream(this.dumpTo, bl);
                inputStream = this.socket.getInputStream();
                outputStream = this.socket.getOutputStream();
                while (this.receivedSize < this.finalSize && this.socket.isConnected()) {
                    int n = this.finalSize - this.receivedSize < (long)PACKET_SIZE ? inputStream.read(byArray, 0, (int)(this.finalSize - this.receivedSize)) : inputStream.read(byArray, 0, PACKET_SIZE);
                    if (n <= 0) continue;
                    this.fileStream.write(byArray, 0, n);
                    this.receivedSize += (long)n;
                    byArray2[0] = (byte)((this.receivedSize & 0xFFFFFFFFFF000000L) >> 24 | 0L);
                    byArray2[1] = (byte)((this.receivedSize & 0xFF0000L) >> 16 | 0L);
                    byArray2[2] = (byte)((this.receivedSize & 0xFF00L) >> 8 | 0L);
                    byArray2[3] = (byte)((this.receivedSize & 0xFFL) >> 0 | 0L);
                    outputStream.write(byArray2, 0, 4);
                    outputStream.flush();
                }
            }
            catch (Exception exception3) {
                if (this.receivedSize == this.finalSize) break block13;
                exception3.printStackTrace();
                exception = exception3;
            }
        }
        try {
            this.fileStream.close();
        }
        catch (Exception exception4) {
            exception4.printStackTrace();
        }
        if (this.receivedSize == this.finalSize) {
            this.fireEvent("RECEIVE_COMPLETE", null);
        } else if (exception != null) {
            this.fireError(exception.getMessage());
        } else {
            this.fireError("incomplete");
        }
    }

    public void fireEvent(String string, String string2) {
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", string);
        this.eventData.put("$data", this.getNickname() + " " + string2);
        this.eventData.put("$parms", string2);
        this.eventData.put("$this", this.toString());
        this.dispatcher.dispatchEvent(this.eventData);
    }

    public void fireError(String string) {
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", "RECEIVE_FAILED");
        this.eventData.put("$data", this.getNickname() + " " + string);
        this.eventData.put("$parms", string);
        this.eventData.put("$this", this.toString());
        this.dispatcher.dispatchEvent(this.eventData);
    }
}

