/*
 * Decompiled with CFR 0.152.
 */
package rero.dck;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import rero.dck.DCapabilities;
import rero.dck.DGroup;
import rero.dck.DItem;
import rero.dck.DParent;
import rero.dck.items.BlankInput;
import rero.dck.items.CharsetInput;
import rero.dck.items.CheckboxInput;
import rero.dck.items.ColorInput;
import rero.dck.items.DirectoryInput;
import rero.dck.items.FileInput;
import rero.dck.items.FloatInput;
import rero.dck.items.FontInput;
import rero.dck.items.LabelInput;
import rero.dck.items.ListInput;
import rero.dck.items.NetworkSelect;
import rero.dck.items.NormalInput;
import rero.dck.items.OptionInput;
import rero.dck.items.OtherInput;
import rero.dck.items.SelectInput;
import rero.dck.items.StringInput;
import rero.dck.items.TabbedInput;
import rero.dck.items.TextInput;

public abstract class DContainer {
    protected LinkedList itemList;
    protected JComponent dialog;
    protected GridBagConstraints constraints = new GridBagConstraints();
    protected DCapabilities capabilities;

    public DContainer() {
        this.itemList = new LinkedList();
        this.constraints.gridwidth = 0;
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.insets = new Insets(0, 0, 2, 0);
    }

    public void installCapabilities(DCapabilities dCapabilities) {
        this.capabilities = dCapabilities;
    }

    public DCapabilities getCapabilities() {
        return this.capabilities;
    }

    public JComponent getDialog() {
        Object object;
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = new JPanel();
        JComponent jComponent = this.setupLayout(this.dialog);
        this.setupDialog();
        int n = 0;
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            object = (DItem)iterator.next();
            if (object.getEstimatedWidth() <= n) continue;
            n = object.getEstimatedWidth();
        }
        object = new GridBagLayout();
        jComponent.setLayout((LayoutManager)object);
        iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            DItem dItem = (DItem)iterator.next();
            dItem.setAlignWidth(n);
            JComponent jComponent2 = dItem.getComponent();
            ((GridBagLayout)object).setConstraints(jComponent2, this.constraints);
            jComponent.add(jComponent2);
        }
        return this.dialog;
    }

    public void setEnabled(boolean bl) {
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            DItem dItem = (DItem)iterator.next();
            dItem.setEnabled(bl);
        }
        this.dialog.setEnabled(bl);
    }

    public void setParent(DParent dParent) {
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            DItem dItem = (DItem)iterator.next();
            dItem.setParent(dParent);
        }
    }

    public void save() {
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            DItem dItem = (DItem)iterator.next();
            dItem.save();
        }
    }

    public void refresh() {
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            DItem dItem = (DItem)iterator.next();
            dItem.refresh();
        }
    }

    public abstract JComponent setupLayout(JComponent var1);

    public abstract void setupDialog();

    public abstract String getTitle();

    public StringInput addStringInput(String string, String string2, String string3, char c) {
        StringInput stringInput = new StringInput(string, string2, string3, 0, c);
        this.itemList.add(stringInput);
        return stringInput;
    }

    public StringInput addStringInput(String string, String string2, String string3, char c, int n) {
        StringInput stringInput = new StringInput(string, string2, string3, n, c);
        this.itemList.add(stringInput);
        return stringInput;
    }

    public CheckboxInput addCheckboxInput(String string, boolean bl, String string2, char c) {
        CheckboxInput checkboxInput = new CheckboxInput(string, bl, string2, c);
        this.itemList.add(checkboxInput);
        return checkboxInput;
    }

    public CheckboxInput addCheckboxInput(String string, boolean bl, String string2, char c, int n) {
        CheckboxInput checkboxInput = new CheckboxInput(string, bl, string2, c, n);
        this.itemList.add(checkboxInput);
        return checkboxInput;
    }

    public FileInput addFileInput(String string, String string2, String string3, char c, int n) {
        FileInput fileInput = new FileInput(string, string2, string3, c, false, n);
        this.itemList.add(fileInput);
        return fileInput;
    }

    public DirectoryInput addDirectoryInput(String string, String string2, String string3, char c, int n) {
        DirectoryInput directoryInput = new DirectoryInput(string, string2, string3, c, n);
        this.itemList.add(directoryInput);
        return directoryInput;
    }

    public ListInput addListInput(String string, String string2, String string3, int n, int n2) {
        ListInput listInput = new ListInput(string, string2, string3, n, n2);
        this.itemList.add(listInput);
        return listInput;
    }

    public FontInput addFontInput(String string, Font font) {
        FontInput fontInput = new FontInput(string, font);
        this.itemList.add(fontInput);
        return fontInput;
    }

    public CharsetInput addCharsetInput(String string, String string2, char c, int n) {
        CharsetInput charsetInput = new CharsetInput(string, string2, c, n);
        this.itemList.add(charsetInput);
        return charsetInput;
    }

    public SelectInput addSelectInput(String string, int n, String[] stringArray, String string2, char c, int n2) {
        SelectInput selectInput = new SelectInput(string, n, stringArray, string2, c, n2);
        this.itemList.add(selectInput);
        return selectInput;
    }

    public OptionInput addOptionInput(String string, String string2, String[] stringArray, String string3, char c, int n) {
        OptionInput optionInput = new OptionInput(string, string2, stringArray, string3, c, n);
        this.itemList.add(optionInput);
        return optionInput;
    }

    public NetworkSelect addNetworkSelector(String string, String string2) {
        NetworkSelect networkSelect = new NetworkSelect(string, string2);
        this.itemList.add(networkSelect);
        return networkSelect;
    }

    public TextInput addTextInput(String string, int n) {
        TextInput textInput = new TextInput(string, n);
        this.itemList.add(textInput);
        return textInput;
    }

    public ColorInput addColorInput(String string, Color color, String string2, char c) {
        ColorInput colorInput = new ColorInput(string, color, string2, c);
        this.itemList.add(colorInput);
        return colorInput;
    }

    public FloatInput addFloatInput(String string, float f, String string2) {
        FloatInput floatInput = new FloatInput(string, f, string2);
        this.itemList.add(floatInput);
        return floatInput;
    }

    public DGroup addDialogGroup(DGroup dGroup) {
        this.itemList.add(dGroup);
        return dGroup;
    }

    public BlankInput addBlankSpace() {
        BlankInput blankInput = new BlankInput();
        this.itemList.add(blankInput);
        return blankInput;
    }

    public LabelInput addLabel(String string, int n) {
        LabelInput labelInput = new LabelInput(string, n);
        this.itemList.add(labelInput);
        return labelInput;
    }

    public NormalInput addLabelNormal(String string, int n) {
        NormalInput normalInput = new NormalInput(string, n);
        this.itemList.add(normalInput);
        return normalInput;
    }

    public DItem addComponent(JComponent jComponent) {
        OtherInput otherInput = new OtherInput(jComponent);
        this.itemList.add(otherInput);
        return otherInput;
    }

    public TabbedInput addTabbedInput() {
        TabbedInput tabbedInput = new TabbedInput();
        this.itemList.add(tabbedInput);
        return tabbedInput;
    }

    public DItem addOther(DItem dItem) {
        this.itemList.add(dItem);
        return dItem;
    }
}

