/*
 * Decompiled with CFR 0.152.
 */
package rero.dck;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class FileLink
extends JComponent {
    protected LinkedList listeners;
    protected JComponent label;
    protected String text = "";

    public FileLink() {
        this.addMouseListener(new TakeAction());
        this.listeners = new LinkedList();
        this.label = this;
    }

    public void setText(String string) {
        this.text = string;
        this.setToolTipText(this.text);
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, Toolkit.getDefaultToolkit().getFontMetrics(this.getFont()).getHeight());
    }

    public void paint(Graphics graphics) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(graphics.getFont());
        for (n = 0; n < this.text.length() && fontMetrics.stringWidth(this.text.substring(0, n)) < this.getWidth(); ++n) {
        }
        if (this.isEnabled()) {
            graphics.setColor(this.label.getForeground());
            graphics.drawLine(0, this.getHeight() - fontMetrics.getDescent() + 1, fontMetrics.stringWidth(this.text.substring(0, n)), this.getHeight() - fontMetrics.getDescent() + 1);
        } else {
            graphics.setColor(this.label.getForeground().brighter());
        }
        graphics.drawString(this.getText().substring(0, n), 0, this.getHeight() - fontMetrics.getDescent());
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void fireEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "?");
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    public class TakeAction
    extends MouseAdapter {
        protected Color original;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (FileLink.this.isEnabled()) {
                FileLink.this.fireEvent();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (FileLink.this.isEnabled()) {
                this.original = FileLink.this.label.getForeground();
                FileLink.this.label.setForeground(UIManager.getColor("TextArea.selectionBackground"));
                FileLink.this.label.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (FileLink.this.isEnabled()) {
                FileLink.this.label.setForeground(this.original);
                FileLink.this.label.repaint();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (FileLink.this.isEnabled()) {
                FileLink.this.label.setForeground(this.original);
                FileLink.this.label.repaint();
            }
        }
    }
}

