/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import rero.config.ClientState;
import rero.dck.SuperInput;

public class ColorInput
extends SuperInput
implements ActionListener {
    protected SolidIcon colorIcon;
    protected JButton button;
    protected Color initial;

    public ColorInput(String string, Color color, String string2, char c) {
        this.setLayout(new FlowLayout(1));
        this.initial = color;
        this.variable = string;
        this.colorIcon = new SolidIcon(this.initial, 18, 18);
        this.button = new JButton(string2, this.colorIcon);
        this.button.setMnemonic(c);
        this.button.addActionListener(this);
        this.add(this.button);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this.button, "Select color...", this.colorIcon.getColor());
        if (color != null) {
            this.colorIcon.setColor(color);
            this.button.repaint();
            this.notifyParent();
        }
    }

    public void save() {
        ClientState.getClientState().setColor(this.getVariable(), this.colorIcon.getColor());
    }

    public void refresh() {
        this.colorIcon.setColor(ClientState.getClientState().getColor(this.getVariable(), this.initial));
        this.button.repaint();
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int n) {
    }

    public JComponent getComponent() {
        return this;
    }

    protected static class SolidIcon
    implements Icon {
        private int width;
        private int height;
        private Color color;

        public SolidIcon(Color color, int n, int n2) {
            this.width = n;
            this.height = n2;
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, this.width - 1, this.height - 1);
        }
    }
}

