/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rero.config.ClientState;
import rero.config.StringList;
import rero.dck.SuperInput;

public class FileListInput
extends SuperInput
implements ActionListener,
ListSelectionListener {
    protected InputListModel model;
    protected JList list;
    protected StringList data;
    protected JTextField fullPath;
    protected JButton addme;
    protected JButton remme;
    protected String desc;
    protected JFileChooser chooser;

    public FileListInput(String string, String string2, String string3, char c, String string4, char c2, int n, int n2) {
        this.desc = string2;
        this.setLayout(new BorderLayout());
        this.data = ClientState.getClientState().getStringList(string);
        this.data.load();
        this.model = new InputListModel();
        this.list = new JList(this.model);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(n, n2));
        this.add((Component)jPanel, "East");
        jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(n, n2));
        this.add((Component)jPanel, "West");
        this.add((Component)new JScrollPane(this.list), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        JLabel jLabel = new JLabel("Selected:  ");
        this.fullPath = new JTextField("no file selected");
        this.fullPath.setBorder(null);
        this.fullPath.setEditable(false);
        this.fullPath.setOpaque(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jLabel, "West");
        jPanel3.add((Component)this.fullPath, "Center");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, n, 0, 0));
        this.addme = new JButton(string3);
        this.addme.setMnemonic(c);
        this.addme.addActionListener(this);
        jPanel2.add(this.addme);
        this.remme = new JButton(string4);
        this.remme.setMnemonic(c2);
        this.remme.addActionListener(this);
        jPanel2.add(this.remme);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel3, "North");
        jPanel4.add((Component)jPanel2, "South");
        this.list.addListSelectionListener(this);
        this.add((Component)jPanel4, "South");
        this.setMinimumSize(new Dimension(n, n2));
    }

    public void save() {
        this.data.save();
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.setSelectedCaption();
        }
    }

    public void setSelectedCaption() {
        if (this.list.getSelectedIndex() > -1 && this.list.getSelectedIndex() < this.list.getModel().getSize()) {
            this.fullPath.setText(this.data.getList().get(this.list.getSelectedIndex()).toString());
        } else {
            this.fullPath.setText("no file selected");
        }
    }

    public void setAlignWidth(int n) {
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.data.load();
        this.model.fireChange();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.remme && this.list.getSelectedIndex() >= 0) {
            this.data.getList().remove(this.list.getSelectedIndex());
            this.model.fireChange();
        }
        if (actionEvent.getSource() == this.addme) {
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
                this.chooser.setApproveButtonText(this.desc);
            }
            if (this.chooser.showDialog(this, null) == 0) {
                this.data.getList().add(this.chooser.getSelectedFile().getAbsolutePath());
                this.model.fireChange();
            }
        }
        this.setSelectedCaption();
        this.notifyParent();
    }

    protected class InputListModel
    extends AbstractListModel {
        protected InputListModel() {
        }

        public void fireChange() {
            FileListInput.this.model.fireContentsChanged(FileListInput.this.model, 0, FileListInput.this.model.getSize());
        }

        public Object getElementAt(int n) {
            return new File((String)FileListInput.this.data.getList().get(n)).getName();
        }

        public int getSize() {
            return FileListInput.this.data.getList().size();
        }
    }
}

