/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rero.config.ClientState;
import rero.dck.SuperInput;

public class FloatInput
extends SuperInput
implements ChangeListener {
    protected JLabel label;
    protected JTextField text;
    protected JSlider slider;
    protected float value;

    public FloatInput(String string, float f, String string2) {
        this.variable = string;
        this.value = f;
        this.setLayout(new BorderLayout(5, 5));
        this.label = new JLabel(string2);
        this.add((Component)this.label, "West");
        int n = (int)(f * 100.0f);
        this.slider = new JSlider(0, 0, 100, n);
        this.slider.setMajorTickSpacing(25);
        this.slider.setMinorTickSpacing(5);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(false);
        this.slider.addChangeListener(this);
        this.add((Component)this.slider, "Center");
        this.text = new JTextField();
        this.text.setEditable(false);
        this.text.setColumns(4);
        this.refresh();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.text);
        this.add((Component)jPanel, "East");
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.slider.getValue() == 0) {
            this.text.setText("off");
        } else {
            this.text.setText(this.slider.getValue() + "%");
        }
        this.notifyParent();
    }

    public void save() {
        ClientState.getClientState().setFloat(this.getVariable(), (float)this.slider.getValue() / 100.0f);
    }

    public int getEstimatedWidth() {
        return (int)this.label.getPreferredSize().getWidth();
    }

    public void setAlignWidth(int n) {
        this.label.setPreferredSize(new Dimension(n, 0));
        this.revalidate();
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        int n = (int)(ClientState.getClientState().getFloat(this.getVariable(), this.value) * 100.0f);
        this.slider.setValue(n);
        if (n == 0) {
            this.text.setText("off");
            return;
        }
        this.text.setText(n + "%");
    }
}

