/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rero.config.ClientState;
import rero.config.StringList;
import rero.dck.SuperInput;
import rero.dialogs.server.ServerData;
import rero.dialogs.server.ServerGroup;
import rero.dialogs.toolkit.ADialog;
import rero.dialogs.toolkit.APanel;

public class NetworkSelect
extends SuperInput
implements ItemListener {
    public static final String ALL_NETWORKS = "All Networks";
    protected JComboBox networks;
    protected JButton add;
    protected JButton delete;
    protected String networkV;
    protected String currentV;
    protected StringList data;
    protected LinkedList listeners = new LinkedList();

    public NetworkSelect(String string, String string2) {
        this.networkV = string;
        this.currentV = string2;
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(" Network:"), "North");
        this.networks = new JComboBox();
        this.networks.setPrototypeDisplayValue("SuperLamerNet");
        this.networks.addItemListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.networks);
        this.add = new JButton("Add");
        this.add.setMnemonic('A');
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkSelect.this.showNetworkDialog();
            }
        });
        this.delete = new JButton("Delete");
        this.delete.setMnemonic('D');
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NetworkSelect.this.networks.getSelectedIndex() > 0) {
                    ClientState.getClientState().setString(NetworkSelect.this.getVariable(), "");
                    ClientState.getClientState().sync();
                    int n = NetworkSelect.this.networks.getSelectedIndex() - 1;
                    NetworkSelect.this.data.remove(NetworkSelect.this.networks.getSelectedItem().toString());
                    NetworkSelect.this.refresh();
                    NetworkSelect.this.networks.setSelectedIndex(n);
                }
            }
        });
        jPanel.add(this.add);
        jPanel.add(this.delete);
        this.add((Component)jPanel, "Center");
    }

    public void showNetworkDialog() {
        NetworkPanel networkPanel = new NetworkPanel();
        networkPanel.setupDialog(null);
        ADialog aDialog = new ADialog(this, "Select a network", networkPanel, null);
        aDialog.pack();
        String string = (String)aDialog.showDialog(null);
        if (string != null && !this.data.isValue(string)) {
            this.data.add(string);
            this.refresh();
            this.networks.setSelectedIndex(this.networks.getItemCount() - 1);
        }
    }

    public void save() {
        if (this.data != null) {
            this.data.save();
        }
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int n) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.fireEvent(this.networks.getSelectedItem().toString());
            this.notifyParent();
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.networks.removeAllItems();
        this.networks.addItem(ALL_NETWORKS);
        if (this.data == null) {
            this.data = ClientState.getClientState().getStringList(this.networkV);
        }
        LinkedList linkedList = this.data.getList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.networks.addItem(iterator.next().toString());
        }
        this.networks.setSelectedIndex(0);
    }

    protected void fireEvent(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 0, string);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ActionListener actionListener = (ActionListener)iterator.next();
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void addDeleteListener(ActionListener actionListener) {
        this.delete.addActionListener(actionListener);
    }

    protected static class NetworkPanel
    extends APanel {
        private JList list;

        protected NetworkPanel() {
        }

        public void setupDialog(Object object) {
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            Iterator iterator = ServerData.getServerData().getGroups().iterator();
            iterator.next();
            iterator.next();
            while (iterator.hasNext()) {
                ServerGroup serverGroup = (ServerGroup)iterator.next();
                defaultListModel.addElement(serverGroup.getName());
            }
            this.list = new JList(defaultListModel);
            this.addComponent(new JLabel("Select a network:"));
            this.addComponent(new JScrollPane(this.list));
        }

        public void processParent(final ADialog aDialog) {
            this.list.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() > 1) {
                        aDialog.closeAndReturn();
                    }
                }
            });
        }

        public Object getValue(Object object) {
            return this.list.getSelectedValue();
        }
    }
}

