/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.dialogs.help.HelpCommands;
import rero.dialogs.help.HelpData;
import rero.dialogs.help.HelpNormal;
import rero.gui.KeyBindings;

public class HelpWindow
extends JDialog
implements HyperlinkListener {
    private static HelpWindow dialog;
    private static HashMap helpData;
    private static HelpData commandData;
    private JEditorPane display;
    private JScrollPane scroller;
    private static Frame frame;

    public static LinkedList getBuiltInAliases() {
        if (commandData == null) {
            commandData = new HelpData();
        }
        return commandData.getAliases();
    }

    public static HelpData getCommandData() {
        return commandData;
    }

    public String getCommand(String string) {
        return commandData.getCommand(string).toString();
    }

    public void scrollTo(String string) {
        this.display.scrollToReference(string);
    }

    public void updateText(String string) {
        this.display.setText(string);
        this.display.setCaretPosition(0);
    }

    public static void initialize(Component component) {
        if (JOptionPane.getFrameForComponent(component) != frame) {
            frame = JOptionPane.getFrameForComponent(component);
            dialog = new HelpWindow(frame);
        }
    }

    public static String showDialog(Component component) {
        KeyBindings.is_dialog_active = true;
        dialog.setLocationRelativeTo(component);
        dialog.setVisible(true);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                KeyBindings.is_dialog_active = false;
            }
        });
        return "";
    }

    private HelpWindow(Frame frame) {
        super(frame, "jIRCii Help", false);
        if (commandData == null) {
            commandData = new HelpData();
        }
        JButton jButton = new JButton("Ok");
        jButton.setMnemonic('O');
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.setVisible(false);
                KeyBindings.is_dialog_active = false;
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)jPanel, "Center");
        HelpNormal helpNormal = new HelpNormal();
        helpNormal.setHelp(this);
        HelpCommands helpCommands = new HelpCommands();
        helpCommands.setHelp(this);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Help", null, helpNormal.getNavigation(), "detailed information.");
        jTabbedPane.addTab("Commands", null, helpCommands.getNavigation(), "jIRCii command reference.");
        jTabbedPane.setSelectedIndex(0);
        jTabbedPane.setPreferredSize(new Dimension(175, 295));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(new Dimension(0, 15));
        jPanel2.add((Component)jPanel3, "North");
        this.display = new JTextPane();
        this.display.setEditable(false);
        this.display.setContentType("text/html");
        this.display.setOpaque(true);
        this.display.setBackground(Color.white);
        this.display.addHyperlinkListener(this);
        this.scroller = new JScrollPane(this.display);
        this.scroller.setVerticalScrollBarPolicy(22);
        this.scroller.setPreferredSize(new Dimension(250, 250));
        jPanel2.add((Component)this.scroller, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel4.add((Component)jButton, "East");
        jPanel4.add((Component)new JPanel(), "Center");
        jPanel.add((Component)jTabbedPane, "West");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.pack();
        this.setSize(new Dimension(600, 363));
        helpNormal.showHelpOn("About");
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                if (hyperlinkEvent.getURL().getRef() != null) {
                    this.display.scrollToReference(hyperlinkEvent.getURL().getRef());
                } else {
                    Runtime.getRuntime().exec(ClientState.getClientState().getString("ui.openfiles", ClientDefaults.ui_openfiles) + " " + hyperlinkEvent.getURL().toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        helpData = new HashMap();
    }
}

