/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import rero.config.ClientState;
import rero.dck.DCapabilities;
import rero.dck.DMain;
import rero.dialogs.AutoWindowDialog;
import rero.dialogs.ClientOptions;
import rero.dialogs.DCCOptions;
import rero.dialogs.ExternalDialog;
import rero.dialogs.FontDialog;
import rero.dialogs.IRCOptions;
import rero.dialogs.IdentDialog;
import rero.dialogs.IgnoreDialog;
import rero.dialogs.ImageDialog;
import rero.dialogs.LoggingDialog;
import rero.dialogs.NotifyDialog;
import rero.dialogs.PerformDialog;
import rero.dialogs.ProxyDialog;
import rero.dialogs.ScriptDialog;
import rero.dialogs.SetupDialog;
import rero.dialogs.SwitchBarDialog;
import rero.dialogs.ThemeDialog;
import rero.dialogs.UIDialog;
import rero.dialogs.WindowsDialog;
import rero.gui.KeyBindings;

public class OptionWindow
extends JDialog
implements DCapabilities,
TreeSelectionListener {
    private static OptionWindow dialog;
    JPanel content;
    JLabel title;
    HashMap dialogs;
    DefaultMutableTreeNode items;
    public DMain current;
    private static Frame frame;

    public void forceSave() {
        if (this.current != null) {
            this.current.save();
            ClientState.getClientState().sync();
        }
    }

    public void refresh() {
        if (this.current != null) {
            this.current.refresh();
        }
    }

    public void closeDialog() {
        KeyBindings.is_dialog_active = false;
        this.setVisible(false);
    }

    public void saveCurrent(DMain dMain) {
        if (this.current != null) {
            this.current.save();
            ClientState.getClientState().sync();
        }
        this.current = dMain;
    }

    public static void displaySpecificDialog(String string) {
        dialog.displayDialog(string);
    }

    public void displayDialog(String string) {
        if (this.dialogs.containsKey(string)) {
            this.changeDialogs((DMain)this.dialogs.get(string));
        }
    }

    public String addDialog(DMain dMain) {
        this.dialogs.put(dMain.getTitle(), dMain);
        dMain.installCapabilities(this);
        return dMain.getTitle();
    }

    public void buildTables() {
        this.dialogs = new HashMap();
        this.items = new DefaultMutableTreeNode("Options");
        this.current = new SetupDialog();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Setup");
        this.items.add(defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(this.current));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new IdentDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new ProxyDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new PerformDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode = new DefaultMutableTreeNode("Client Options");
        this.items.add(defaultMutableTreeNode);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new IRCOptions()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new ClientOptions()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new DCCOptions()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new LoggingDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new AutoWindowDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode = new DefaultMutableTreeNode("Scripts");
        this.items.add(defaultMutableTreeNode);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new ScriptDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new ThemeDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode = new DefaultMutableTreeNode("User Lists");
        this.items.add(defaultMutableTreeNode);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new NotifyDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new IgnoreDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode = new DefaultMutableTreeNode("Interface Options");
        this.items.add(defaultMutableTreeNode);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new UIDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new FontDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new SwitchBarDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new WindowsDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new ImageDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.addDialog(new ExternalDialog()));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        JTree jTree = (JTree)treeSelectionEvent.getSource();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        DMain dMain = (DMain)this.dialogs.get(defaultMutableTreeNode.getUserObject());
        this.changeDialogs(dMain);
    }

    private void changeDialogs(DMain dMain) {
        if (dMain == null) {
            return;
        }
        this.title.setText(dMain.getDescription());
        this.saveCurrent(dMain);
        this.content.removeAll();
        this.content.add((Component)dMain.getDialog(), "Center");
        dMain.refresh();
        this.content.revalidate();
        this.content.repaint();
    }

    public static void initialize(Component component) {
        if (JOptionPane.getFrameForComponent(component) != frame) {
            frame = JOptionPane.getFrameForComponent(component);
            dialog = new OptionWindow(frame);
        }
    }

    public static String showDialog(Component component) {
        KeyBindings.is_dialog_active = true;
        dialog.setLocationRelativeTo(component);
        dialog.setVisible(true);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                KeyBindings.is_dialog_active = false;
            }
        });
        dialog.refresh();
        return "";
    }

    private OptionWindow(Frame frame) {
        super(frame, "jIRCii Options", false);
        this.buildTables();
        JButton jButton = new JButton("OK");
        jButton.setMnemonic('O');
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic('C');
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionWindow.this.forceSave();
                dialog.setVisible(false);
                KeyBindings.is_dialog_active = false;
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.setVisible(false);
                dialog = null;
                OptionWindow.frame = null;
                KeyBindings.is_dialog_active = false;
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        jPanel3.setPreferredSize(new Dimension(165, 295));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        JTree jTree = new JTree(this.items);
        jTree.setRootVisible(false);
        jTree.setToggleClickCount(1);
        jTree.getSelectionModel().setSelectionMode(0);
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandPath(jTree.getPathForRow(i));
        }
        jTree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel2.add((Component)new JLabel("Options:"), "North");
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(5, 5));
        JPanel jPanel5 = new JPanel();
        this.title = new JLabel("Configuration");
        jPanel5.add((Component)this.title, "Center");
        jPanel5.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.add((Component)jPanel5, "North");
        this.content = new JPanel();
        this.content.setLayout(new BorderLayout());
        this.content.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.add((Component)this.content, "Center");
        this.content.add((Component)this.current.getDialog(), "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(5, 5));
        JPanel jPanel7 = new JPanel();
        GridLayout gridLayout = new GridLayout(1, 3);
        gridLayout.setHgap(5);
        jPanel7.setLayout(gridLayout);
        jPanel7.add(jButton);
        jPanel7.add(jButton2);
        jPanel6.add((Component)jPanel7, "East");
        jPanel6.add((Component)new JPanel(), "Center");
        jPanel.add((Component)jPanel3, "West");
        jPanel.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel6, "South");
        this.pack();
        this.setSize(new Dimension(520, 400));
    }
}

