/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs.help;

import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import rero.config.ClientState;
import rero.dialogs.help.HelperObject;

public class HelpNormal
extends HelperObject
implements TreeSelectionListener {
    private static HashMap helpData = new HashMap();
    protected String lastKey = "";

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        JTree jTree = (JTree)treeSelectionEvent.getSource();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        this.showHelpOn(defaultMutableTreeNode.getUserObject().toString());
    }

    public void showHelpOn(String string) {
        if (HelpNormal.isTutorial(string)) {
            if (this.lastKey.equals("IRC Tutorial")) {
                this.help.scrollTo(helpData.get(string).toString());
            } else {
                this.help.updateText(this.getHelpFor("IRC Tutorial"));
            }
        } else if (HelpNormal.isScriptTutorial(string)) {
            if (this.lastKey.equals("Script Tutorial")) {
                this.help.scrollTo(helpData.get(string).toString());
            } else {
                this.help.updateText(this.getHelpFor("Script Tutorial"));
            }
        } else {
            this.updateText(this.getHelpFor(string));
        }
    }

    private String getHelpFor(String string) {
        this.lastKey = string;
        if (helpData.get(string) == null) {
            String string2 = ClientState.getClientState().getHelpString(string);
            if (string2 != null) {
                helpData.put(string, string2);
                return string2;
            }
            return null;
        }
        String string3 = helpData.get(string).toString();
        return string3;
    }

    private static boolean isTutorial(String string) {
        return string.equals("Introduction") || string.equals("Chatting") || string.equals("Beyond Basics");
    }

    private static boolean isScriptTutorial(String string) {
        return string.equals("Aliases") || string.equals("Events") || string.equals("Resources") || string.equals("Introduction ");
    }

    private DefaultMutableTreeNode initHelp() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Help");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("About");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Contributors");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("General");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("Colored Text");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("KB Shortcuts");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Script Tutorial");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("Introduction ");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("Aliases");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("Events");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("Resources");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        helpData.put("Introduction", "part1");
        helpData.put("Chatting", "part2");
        helpData.put("Beyond Basics", "part3");
        helpData.put("Introduction ", "part1");
        helpData.put("Aliases", "part2");
        helpData.put("Events", "part3");
        helpData.put("Resources", "part4");
        return defaultMutableTreeNode;
    }

    public JComponent getNavigationComponent() {
        JTree jTree = new JTree(this.initHelp());
        jTree.setRootVisible(false);
        jTree.setToggleClickCount(0);
        jTree.getSelectionModel().setSelectionMode(0);
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandPath(jTree.getPathForRow(i));
        }
        jTree.addTreeSelectionListener(this);
        return jTree;
    }
}

