/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs.server;

import java.util.ArrayList;
import java.util.Iterator;
import rero.dialogs.server.Server;

public class ServerGroup
implements Comparable {
    protected String name;
    protected ArrayList servers;
    protected int number;

    public ServerGroup(String string) {
        this(string, new ArrayList());
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public int getNumber() {
        return this.number;
    }

    public ServerGroup(String string, ArrayList arrayList) {
        this.name = string;
        this.servers = arrayList;
    }

    public void clear() {
        this.servers.clear();
    }

    public Server getServerByName(String string) {
        Iterator iterator = this.servers.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            if (!server.getHost().equals(string)) continue;
            return server;
        }
        return null;
    }

    public ArrayList getServers() {
        return this.servers;
    }

    public String getName() {
        return this.name;
    }

    public void addServer(Server server) {
        this.servers.add(server);
    }

    public void removeServer(Server server) {
        this.servers.remove(server);
    }

    public String toString() {
        return this.name;
    }

    public boolean isValid() {
        return !this.servers.isEmpty();
    }

    public int compareTo(Object object) {
        ServerGroup serverGroup = (ServerGroup)object;
        return this.name.toUpperCase().compareTo(serverGroup.getName().toUpperCase());
    }
}

