/*
 * Decompiled with CFR 0.152.
 */
package rero.gui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.IRCSession;
import rero.net.SocketInformation;
import rero.util.ClientUtils;
import rero.util.StringUtils;

public class BuiltInLogger {
    protected static boolean isEnabled = ClientState.getClientState().isOption("log.enabled", false);
    protected static boolean timeStamp = ClientState.getClientState().isOption("log.timestamp", true);
    protected static boolean stripColors = ClientState.getClientState().isOption("log.strip", true);
    protected static HashMap logHandles = new HashMap();
    protected static ClientStateListener listener = null;
    protected SocketInformation socket = null;
    protected IRCSession client = null;

    public BuiltInLogger(IRCSession iRCSession) {
        this.client = iRCSession;
        if (listener == null) {
            listener = new LoggerPropListener();
            ClientState.getClientState().addClientStateListener("log.enabled", listener);
            ClientState.getClientState().addClientStateListener("log.timestamp", listener);
            ClientState.getClientState().addClientStateListener("log.strip", listener);
            ClientState.getClientState().addClientStateListener("log.saveto", listener);
        }
    }

    public void logMessage(String string, String string2) {
        try {
            PrintWriter printWriter;
            if (this.socket == null && this.client.getCapabilities() != null && this.client.getCapabilities().getSocketConnection() != null) {
                this.socket = this.client.getCapabilities().getSocketConnection().getSocketInformation();
            }
            if ((printWriter = this.getFileHandle(this.socket, string)) != null) {
                if (stripColors) {
                    string2 = StringUtils.strip(string2);
                }
                if (timeStamp) {
                    string2 = ClientUtils.TimeDateStamp(ClientUtils.ctime()) + " " + string2;
                }
                printWriter.println(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isEnabled() {
        return isEnabled;
    }

    public static String getLogFileName(SocketInformation socketInformation, String string) {
        String string2 = "Unknown";
        if (socketInformation != null && socketInformation.network != null && socketInformation.network.length() > 0) {
            string2 = socketInformation.network;
        }
        if (string.length() == 0) {
            string = "%STATUS%";
        }
        if (string.charAt(0) == '=') {
            string2 = "dcc_chat";
            string = string.substring(1, string.length());
        }
        File file = new File(ClientState.getClientState().getString("log.saveto", ClientDefaults.log_saveto));
        file = new File(file, string2);
        String string3 = string.replaceAll("[^\\w\\#\\!\\$\\(\\)\\@\\^\\`\\{\\}\\']", "_");
        File file2 = new File(file, string3 + ".log");
        return file2.getAbsolutePath();
    }

    private PrintWriter getFileHandle(SocketInformation socketInformation, String string) {
        String string2 = "Unknown";
        if (socketInformation != null && socketInformation.network != null && socketInformation.network.length() > 0) {
            string2 = socketInformation.network;
        }
        if (string.length() == 0) {
            string = "%STATUS%";
        }
        if (string.charAt(0) == '=') {
            string2 = "dcc_chat";
            string = string.substring(1, string.length());
        }
        if (logHandles.containsKey(string2 + string)) {
            return (PrintWriter)logHandles.get(string2 + string);
        }
        try {
            File file = new File(ClientState.getClientState().getString("log.saveto", ClientDefaults.log_saveto));
            file = new File(file, string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            String string3 = string.replaceAll("[^\\w\\#\\!\\$\\(\\)\\@\\^\\`\\{\\}\\']", "_");
            File file2 = new File(file, string3 + ".log");
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2, true), true);
            logHandles.put(string2 + string, printWriter);
            return printWriter;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static class LoggerPropListener
    implements ClientStateListener {
        private LoggerPropListener() {
        }

        public void propertyChanged(String string, String string2) {
            if (string.equals("log.enabled")) {
                isEnabled = ClientState.getClientState().isOption("log.enabled", false);
            }
            if (string.equals("log.saveto")) {
                Iterator iterator = logHandles.values().iterator();
                while (iterator.hasNext()) {
                    PrintWriter printWriter = (PrintWriter)iterator.next();
                    try {
                        printWriter.flush();
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                logHandles.clear();
            }
            timeStamp = ClientState.getClientState().isOption("log.timestamp", true);
            stripColors = ClientState.getClientState().isOption("log.strip", true);
        }
    }
}

