/*
 * Decompiled with CFR 0.152.
 */
package rero.gui;

import java.util.Iterator;
import java.util.Set;
import rero.gui.BuiltInLogger;
import rero.gui.IRCSession;
import rero.gui.script.WindowDataListener;
import rero.gui.windows.ChannelWindow;
import rero.gui.windows.QueryWindow;
import rero.gui.windows.StatusWindow;
import rero.ircfw.Channel;

public class UICapabilities {
    protected IRCSession clientSession;
    protected WindowDataListener listeners = null;
    protected BuiltInLogger logger = null;

    public UICapabilities(IRCSession iRCSession) {
        this.clientSession = iRCSession;
        this.logger = new BuiltInLogger(iRCSession);
    }

    public void logMessage(String string, String string2) {
        if (this.logger.isEnabled()) {
            this.logger.logMessage(string, string2);
        }
    }

    public void setQuery(String string) {
        this.clientSession.getStatusWindow().setQuery(string);
    }

    public String getQuery() {
        return this.clientSession.getActiveWindow().getQuery();
    }

    public boolean isActive(String string) {
        return this.clientSession.getStatusWindow().getQuery().toLowerCase().equals(string.toLowerCase()) || this.clientSession.isWindow(string);
    }

    public boolean isWindow(String string) {
        return this.clientSession.isWindow(string);
    }

    protected boolean shouldContinue(String string, String string2) {
        return string2 != null && (this.listeners == null || this.listeners.shouldContinue(string, string2));
    }

    public void printActive(String string) {
        if (this.shouldContinue(this.clientSession.getActiveWindow().getQuery(), string)) {
            this.clientSession.getActiveWindow().flag();
            this.clientSession.getActiveWindow().getDisplay().addText(string);
            if (this.logger.isEnabled()) {
                this.logger.logMessage(this.clientSession.getActiveWindow().getName(), string);
            }
        }
    }

    public void printAll(String string) {
        Iterator iterator = this.clientSession.getAllWindows().iterator();
        while (iterator.hasNext()) {
            StatusWindow statusWindow = (StatusWindow)iterator.next();
            if (!statusWindow.isLegalWindow() || !this.shouldContinue(statusWindow.getQuery(), string)) continue;
            statusWindow.getDisplay().addText(string);
            if (!this.logger.isEnabled()) continue;
            this.logger.logMessage(statusWindow.getName(), string);
        }
    }

    public void printStatus(String string) {
        if (this.shouldContinue(this.clientSession.getStatusWindow().getQuery(), string) && this.clientSession.getStatusWindow().getDisplay() != null) {
            this.clientSession.getStatusWindow().flag();
            this.clientSession.getStatusWindow().getDisplay().addText(string);
            if (this.logger.isEnabled()) {
                this.logger.logMessage("%STATUS%", string);
            }
        }
    }

    public void printNormal(String string, String string2) {
        if (this.shouldContinue(string, string2)) {
            StatusWindow statusWindow = this.clientSession.getWindow(string);
            statusWindow.flag();
            statusWindow.getDisplay().addText(string2);
            if (this.logger.isEnabled()) {
                this.logger.logMessage(statusWindow.getName(), string2);
            }
        }
    }

    public void printToTargets(Set set, String string, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = set.iterator();
        String string2 = this.getQuery();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (this.clientSession.isWindow(string3)) {
                this.printNormal(string3, string);
                bl3 = true;
                if (!string3.equals(string2)) continue;
                bl = false;
                continue;
            }
            bl2 = true;
        }
        if (bl2 || !bl3 || bl) {
            this.printStatus(string);
        }
    }

    public void printChunk(String string, String string2, String[] stringArray, double d) {
        if (this.shouldContinue(string, string2)) {
            this.clientSession.getWindow(string).getDisplay().addTextTable(string2, stringArray, d);
            if (this.logger.isEnabled()) {
                this.logger.logMessage(this.clientSession.getWindow(string).getName(), string2);
            }
        }
    }

    public void printRaw(String string, String string2) {
        StatusWindow statusWindow = this.clientSession.getWindow(string);
        if (string != null) {
            statusWindow.flag();
            statusWindow.getDisplay().addText(string2);
            if (this.logger.isEnabled()) {
                this.logger.logMessage(statusWindow.getName(), string2);
            }
        }
    }

    public void clearScreen(String string) {
        if (string == null || string.length() == 0) {
            this.clientSession.getActiveWindow().getDisplay().clear();
        } else if ("%ALL%".equals(string)) {
            this.clientSession.getStatusWindow().getDisplay().clear();
            this.clientSession.getStatusWindow().unflag();
            Iterator iterator = this.clientSession.getAllWindows().iterator();
            while (iterator.hasNext()) {
                StatusWindow statusWindow = (StatusWindow)iterator.next();
                if (!statusWindow.isLegalWindow()) continue;
                statusWindow.getDisplay().clear();
                statusWindow.unflag();
            }
        } else {
            this.clientSession.getWindow(string).getDisplay().clear();
            this.clientSession.getWindow(string).unflag();
        }
    }

    public void openQueryWindow(String string, boolean bl) {
        if (!this.clientSession.isWindow(string)) {
            QueryWindow queryWindow = this.clientSession.createQueryWindow(string, bl);
        }
    }

    public void closeWindow(String string) {
        if (this.clientSession.isWindow(string)) {
            this.clientSession.getWindow(string).getWindow().closeWindow();
        }
    }

    public void openListWindow() {
        this.clientSession.createListWindow();
    }

    public void openDCCWindow() {
        this.clientSession.createDCCWindow();
    }

    public void openChannelWindow(Channel channel) {
        if (!this.clientSession.isWindow(channel.getName())) {
            ChannelWindow channelWindow = this.clientSession.createChannelWindow(channel);
        }
    }

    public void notifyActiveWindow() {
        this.clientSession.getActiveWindow().touch();
    }

    public void notifyWindow(String string) {
        this.clientSession.getWindow(string).touch();
    }

    public void renameWindow(String string, String string2) {
        this.clientSession.renameWindow(string, string2);
    }

    public void setListener(WindowDataListener windowDataListener) {
        this.listeners = windowDataListener;
    }

    public void showSearchDialog(String string) {
        StatusWindow statusWindow = this.clientSession.getWindow(string);
        if (statusWindow.isLegalWindow()) {
            if (string.equals("%STATUS%")) {
                string = "Status";
            }
            statusWindow.getDisplay().showSearchDialog("Search " + string);
        }
    }
}

