/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.background;

import java.awt.Graphics;
import javax.swing.JToolBar;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.background.BackgroundProperties;
import rero.gui.background.BackgroundUtil;

public class BackgroundToolBar
extends JToolBar
implements ClientStateListener {
    protected static BackgroundProperties bgProperties;

    public BackgroundToolBar() {
        if (bgProperties == null) {
            bgProperties = new BackgroundProperties("statusbar", 0);
        }
        ClientState.getClientState().addClientStateListener("statusbar", this);
    }

    public boolean isOpaque() {
        return bgProperties.getType() == 0;
    }

    public void propertyChanged(String string, String string2) {
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = graphics.getClipBounds().x;
        int n2 = graphics.getClipBounds().y;
        int n3 = graphics.getClipBounds().width;
        int n4 = graphics.getClipBounds().height;
        switch (bgProperties.getType()) {
            case 0: {
                super.paint(graphics);
                this.paintBorder(graphics);
                break;
            }
            case 1: {
                graphics.setColor(bgProperties.getColor());
                graphics.fillRect(n, n2, n3, n4);
                this.paintChildren(graphics);
                break;
            }
            case 2: {
                BackgroundUtil.drawTintedTransparency(this, graphics, bgProperties);
                this.paintChildren(graphics);
                break;
            }
            case 3: {
                BackgroundUtil.drawBackground(this, graphics, bgProperties);
                this.paintChildren(graphics);
            }
        }
    }
}

