/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.background;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.ImageIcon;
import rero.gui.background.BackgroundProperties;

public class BackgroundUtil {
    public static final int STYLE_TILE = 0;
    public static final int STYLE_CENTER = 1;
    public static final int STYLE_FILL = 2;
    public static final int STYLE_STRETCHED = 3;
    public static final int BG_DEFAULT = 0;
    public static final int BG_SOLID = 1;
    public static final int BG_TRANSPARENT = 2;
    public static final int BG_IMAGE = 3;

    public static void drawBackground(Component component, Graphics graphics, BackgroundProperties backgroundProperties) {
        if (backgroundProperties.getImage(component) == null) {
            BackgroundUtil.drawSafeBackground(component, graphics, backgroundProperties);
            return;
        }
        switch (backgroundProperties.getStyle()) {
            case 0: {
                BackgroundUtil.drawImageTiled(component, graphics, backgroundProperties);
                break;
            }
            case 2: {
                BackgroundUtil.drawImageFill(component, graphics, backgroundProperties);
                break;
            }
            case 3: {
                BackgroundUtil.drawImageStretched(component, graphics, backgroundProperties);
                break;
            }
            case 1: {
                BackgroundUtil.drawImageCentered(component, graphics, backgroundProperties);
                break;
            }
            default: {
                BackgroundUtil.drawImageTiled(component, graphics, backgroundProperties);
            }
        }
    }

    public static void drawTintedTransparency(Component component, Graphics graphics, BackgroundProperties backgroundProperties) {
        if (backgroundProperties.getTint() > 0.0f) {
            int n = graphics.getClipBounds().x;
            int n2 = graphics.getClipBounds().y;
            int n3 = graphics.getClipBounds().width;
            int n4 = graphics.getClipBounds().height;
            graphics.setColor(backgroundProperties.getColor());
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, backgroundProperties.getTint());
            graphics2D.setComposite(alphaComposite);
            graphics2D.fillRect(n, n2, n3, n4);
            graphics2D.setComposite(composite);
        }
    }

    public static void drawSafeBackground(Component component, Graphics graphics, BackgroundProperties backgroundProperties) {
        int n = graphics.getClipBounds().x;
        int n2 = graphics.getClipBounds().y;
        int n3 = graphics.getClipBounds().width;
        int n4 = graphics.getClipBounds().height;
        graphics.setColor(backgroundProperties.getColor());
        graphics.fillRect(n, n2, n3, n4);
    }

    public static void drawImageFill(Component component, Graphics graphics, BackgroundProperties backgroundProperties) {
        Image image = backgroundProperties.getTransformedImage();
        Dimension dimension = null;
        int n = 0;
        int n2 = 0;
        if (backgroundProperties.isRelative()) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n = Math.abs(component.getLocationOnScreen().x) % Toolkit.getDefaultToolkit().getScreenSize().width;
            n2 = Math.abs(component.getLocationOnScreen().y) % Toolkit.getDefaultToolkit().getScreenSize().height;
        } else {
            dimension = component.getSize();
        }
        if (image == null || image.getWidth(null) != (int)dimension.getWidth() || image.getHeight(null) != (int)dimension.getHeight()) {
            Image image2 = backgroundProperties.getImage(component);
            Image image3 = component.createImage((int)dimension.getWidth(), (int)dimension.getHeight());
            Graphics2D graphics2D = (Graphics2D)image3.getGraphics();
            graphics2D.drawImage(image2, 0, 0, (int)dimension.getWidth(), (int)dimension.getHeight(), null);
            graphics2D.dispose();
            backgroundProperties.setTransformedImage(image3);
            graphics.drawImage(image3, 0 - n, 0 - n2, null);
            return;
        }
        graphics.drawImage(image, 0 - n, 0 - n2, null);
    }

    public static void drawImageCentered(Component component, Graphics graphics, BackgroundProperties backgroundProperties) {
        Image image = backgroundProperties.getTransformedImage();
        Dimension dimension = null;
        int n = 0;
        int n2 = 0;
        if (backgroundProperties.isRelative()) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n = Math.abs(component.getLocationOnScreen().x) % Toolkit.getDefaultToolkit().getScreenSize().width;
            n2 = Math.abs(component.getLocationOnScreen().y) % Toolkit.getDefaultToolkit().getScreenSize().height;
        } else {
            dimension = component.getSize();
        }
        if (image == null || image.getWidth(null) != (int)dimension.getWidth() || image.getHeight(null) != (int)dimension.getHeight()) {
            Image image2 = backgroundProperties.getImage(component);
            Image image3 = component.createImage((int)dimension.getWidth(), (int)dimension.getHeight());
            int n3 = ((int)dimension.getWidth() - image2.getWidth(null)) / 2;
            int n4 = ((int)dimension.getHeight() - image2.getHeight(null)) / 2;
            Graphics2D graphics2D = (Graphics2D)image3.getGraphics();
            graphics2D.setColor(backgroundProperties.getColor());
            graphics2D.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
            graphics2D.drawImage(image2, n3, n4, image2.getWidth(null), image2.getHeight(null), null);
            graphics2D.dispose();
            backgroundProperties.setTransformedImage(image3);
            graphics.drawImage(image3, 0 - n, 0 - n2, null);
            return;
        }
        graphics.drawImage(image, 0 - n, 0 - n2, null);
    }

    public static void drawImageStretched(Component component, Graphics graphics, BackgroundProperties backgroundProperties) {
        Image image = backgroundProperties.getTransformedImage();
        Dimension dimension = null;
        int n = 0;
        int n2 = 0;
        if (backgroundProperties.isRelative()) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n = Math.abs(component.getLocationOnScreen().x) % Toolkit.getDefaultToolkit().getScreenSize().width;
            n2 = Math.abs(component.getLocationOnScreen().y) % Toolkit.getDefaultToolkit().getScreenSize().height;
        } else {
            dimension = component.getSize();
        }
        if (image == null || image.getWidth(null) != (int)dimension.getWidth() || image.getHeight(null) != (int)dimension.getHeight()) {
            float f;
            Image image2 = backgroundProperties.getImage(component);
            Image image3 = component.createImage((int)dimension.getWidth(), (int)dimension.getHeight());
            float f2 = (float)dimension.getWidth() / (float)image2.getWidth(null);
            float f3 = f2 > (f = (float)dimension.getHeight() / (float)image2.getHeight(null)) ? f2 : f;
            int n3 = (int)((float)image2.getWidth(null) * f3);
            int n4 = (int)((float)image2.getHeight(null) * f3);
            int n5 = ((int)dimension.getWidth() - n3) / 2;
            int n6 = ((int)dimension.getHeight() - n4) / 2;
            Graphics2D graphics2D = (Graphics2D)image3.getGraphics();
            graphics2D.setColor(backgroundProperties.getColor());
            graphics2D.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
            graphics2D.drawImage(image2, n5, n6, n3, n4, null);
            graphics2D.dispose();
            backgroundProperties.setTransformedImage(image3);
            graphics.drawImage(image3, 0 - n, 0 - n2, null);
            return;
        }
        graphics.drawImage(image, 0 - n, 0 - n2, null);
    }

    public static void drawImageTiled(Component component, Graphics graphics, BackgroundProperties backgroundProperties) {
        Image image = backgroundProperties.getImage(component);
        int n = graphics.getClipBounds().y;
        int n2 = graphics.getClipBounds().height + n;
        n -= image.getHeight(null);
        int n3 = graphics.getClipBounds().x;
        int n4 = graphics.getClipBounds().width + n3;
        n3 -= image.getWidth(null);
        int n5 = 0;
        int n6 = 0;
        if (backgroundProperties.isRelative()) {
            n5 = Math.abs(component.getLocationOnScreen().x) % Toolkit.getDefaultToolkit().getScreenSize().width;
            n6 = Math.abs(component.getLocationOnScreen().y) % Toolkit.getDefaultToolkit().getScreenSize().height;
        }
        int n7 = component.getWidth();
        int n8 = component.getHeight();
        int n9 = 0 - n6;
        for (int i = 0 - n5; i < n7; i += image.getWidth(null)) {
            while (n9 < n8) {
                if (i >= n3 && i <= n4 && n9 >= n && n9 <= n2) {
                    graphics.drawImage(image, i, n9, null);
                }
                n9 += image.getHeight(null);
            }
            n9 = 0 - n6;
        }
    }

    public static Image getManagedImage(Component component, String string, float f, Color color) {
        if (!new File(string).exists()) {
            return null;
        }
        Image image = new ImageIcon(string).getImage();
        if (f > 0.0f) {
            Image image2 = component.createImage(image.getWidth(null), image.getHeight(null));
            Graphics2D graphics2D = (Graphics2D)image2.getGraphics();
            Composite composite = graphics2D.getComposite();
            graphics2D.drawImage(image, 0, 0, null);
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, image2.getWidth(null), image2.getHeight(null));
            graphics2D.dispose();
            return image2;
        }
        return image;
    }
}

