/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.input;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.input.InputBorder;
import rero.gui.input.InputListener;
import rero.gui.input.UserInputEvent;
import text.AttributedText;
import text.ModifyColorMapDialog;
import text.TextSource;

public class InputField
extends JTextField
implements KeyListener,
ActionListener,
MouseListener,
ClientStateListener {
    protected Border defaultBorder;
    protected LinkedList listeners;
    protected UserInputEvent event;
    private ArrayList commandHistory;
    private ListIterator commandIterator;
    private int maxCommands = 30;
    private boolean previousKeyUpArrow = true;
    protected InputBorder indent;

    public void cleanup() {
        this.listeners = null;
        this.getParent().remove(this);
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            this.removeMouseListener(mouseListenerArray[i]);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        AttributedText attributedText;
        if (mouseEvent.getButton() == 1 && mouseEvent.isShiftDown() && this.indent != null && (attributedText = this.indent.getAttributes().getAttributesAt(mouseEvent.getX() - this.defaultBorder.getBorderInsets((Component)this).left)) != null) {
            if (attributedText.backIndex != -1 && mouseEvent.isControlDown()) {
                ModifyColorMapDialog.showModifyColorMapDialog((JComponent)mouseEvent.getSource(), attributedText.backIndex);
            } else {
                ModifyColorMapDialog.showModifyColorMapDialog((JComponent)mouseEvent.getSource(), attributedText.foreIndex);
            }
            this.repaint();
        }
    }

    public boolean isFocusable() {
        return true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public InputField() {
        this.setUI(new BasicTextFieldUI());
        this.setOpaque(false);
        this.defaultBorder = BorderFactory.createEmptyBorder(1, 2, 1, 1);
        this.setBorder(this.defaultBorder);
        this.addActionListener(this);
        this.addKeyListener(this);
        this.listeners = new LinkedList();
        this.event = new UserInputEvent();
        this.event.source = this;
        this.indent = null;
        this.addMouseListener(this);
        this.rehashColors();
        ClientState.getClientState().addClientStateListener("ui.editcolor", this);
        ClientState.getClientState().addClientStateListener("ui.font", this);
        this.commandHistory = new ArrayList(this.maxCommands + 1);
        this.commandIterator = this.commandHistory.listIterator();
    }

    public void propertyChanged(String string, String string2) {
        this.rehashColors();
    }

    public void rehashColors() {
        Color color = ClientState.getClientState().getColor("ui.editcolor", ClientDefaults.ui_editcolor);
        this.setForeground(color);
        this.setCaretColor(color.brighter());
        this.setFont(ClientState.getClientState().getFont("ui.font", ClientDefaults.ui_font));
        this.revalidate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.event.text = actionEvent.getActionCommand();
        if (this.event.text.length() <= 0) {
            this.fireInputEvent();
            return;
        }
        this.fireInputEvent();
    }

    public void addInputListener(InputListener inputListener) {
        this.listeners.addFirst(inputListener);
    }

    public void fireInputEvent() {
        ListIterator listIterator = this.listeners.listIterator();
        this.addToHistory(this.event.text);
        this.setText("");
        while (listIterator.hasNext()) {
            InputListener inputListener = (InputListener)listIterator.next();
            inputListener.onInput(this.event);
        }
        this.resetIterator(false);
        this.event.reset();
    }

    public String getIndent() {
        if (this.indent != null) {
            return this.indent.getText();
        }
        return "";
    }

    public void setIndent(String string) {
        if (string != null) {
            this.indent = new InputBorder(string);
            this.setBorder(new CompoundBorder(this.defaultBorder, this.indent));
        } else {
            this.setBorder(this.defaultBorder);
            this.indent = null;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\b' && this.getText().length() == 0) {
            keyEvent.consume();
        }
    }

    public String getCurrentText() {
        return this.getText();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getModifiers() == 2) {
            int n = this.getCaretPosition() + 1;
            switch (keyEvent.getKeyCode()) {
                case 75: {
                    this.setText(this.getText().substring(0, this.getCaretPosition()) + '\u0003' + this.getText().substring(this.getCaretPosition(), this.getText().length()));
                    this.setCaretPosition(n);
                    keyEvent.consume();
                    return;
                }
                case 85: {
                    this.setText(this.getText().substring(0, this.getCaretPosition()) + '\u001f' + this.getText().substring(this.getCaretPosition(), this.getText().length()));
                    this.setCaretPosition(n);
                    keyEvent.consume();
                    return;
                }
                case 66: {
                    this.setText(this.getText().substring(0, this.getCaretPosition()) + '\u0002' + this.getText().substring(this.getCaretPosition(), this.getText().length()));
                    this.setCaretPosition(n);
                    keyEvent.consume();
                    return;
                }
                case 79: {
                    this.setText(this.getText().substring(0, this.getCaretPosition()) + '\u000f' + this.getText().substring(this.getCaretPosition(), this.getText().length()));
                    this.setCaretPosition(n);
                    keyEvent.consume();
                    return;
                }
                case 82: {
                    this.setText(this.getText().substring(0, this.getCaretPosition()) + '\u0016' + this.getText().substring(this.getCaretPosition(), this.getText().length()));
                    this.setCaretPosition(n);
                    keyEvent.consume();
                    return;
                }
            }
        }
        if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() != 0) {
            this.resetIterator();
            this.event.text = this.getText();
            this.fireInputEvent();
            keyEvent.consume();
            return;
        }
        if (keyEvent.getKeyCode() == 38) {
            if (this.commandIterator.hasPrevious()) {
                String string = String.valueOf(this.commandIterator.previous());
                if (!this.previousKeyUpArrow && this.commandIterator.hasPrevious()) {
                    this.setText(String.valueOf(this.commandIterator.previous()));
                } else {
                    this.setText(string);
                }
            } else {
                keyEvent.consume();
            }
            this.previousKeyUpArrow = true;
        }
        if (keyEvent.getKeyCode() == 40) {
            if (this.commandIterator.hasNext()) {
                if (this.commandIterator.hasNext() && this.commandIterator.nextIndex() + 1 == this.commandHistory.size() && this.previousKeyUpArrow) {
                    this.resetIterator(false);
                    this.previousKeyUpArrow = true;
                    this.setText("");
                } else {
                    String string = String.valueOf(this.commandIterator.next());
                    if (this.previousKeyUpArrow && this.commandIterator.hasNext()) {
                        this.setText(String.valueOf(this.commandIterator.next()));
                    } else {
                        this.setText(string);
                    }
                    this.previousKeyUpArrow = false;
                }
            } else {
                this.setText("");
                Object var2_5 = null;
                this.previousKeyUpArrow = true;
            }
            keyEvent.consume();
        }
    }

    private void resetIterator() {
        this.resetIterator(true);
    }

    private void resetIterator(boolean bl) {
        if (bl) {
            while (this.commandIterator.hasPrevious()) {
                this.commandIterator.previous();
            }
        } else {
            while (this.commandIterator.hasNext()) {
                this.commandIterator.next();
            }
        }
    }

    private void addToHistory(String string) {
        this.commandExistsInHistory(string, true);
        this.resetIterator(false);
        this.commandIterator.add(string);
        if (this.commandHistory.size() == this.maxCommands + 1 && this.maxCommands > 0) {
            this.resetIterator();
            this.commandIterator.remove();
            this.resetIterator(false);
        }
    }

    private boolean commandExistsInHistory(String string, boolean bl) {
        this.resetIterator();
        while (this.commandIterator.hasNext()) {
            if (!this.commandIterator.next().equals(string)) continue;
            if (bl) {
                this.commandIterator.remove();
            }
            return true;
        }
        return false;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void paint(Graphics graphics) {
        TextSource.initGraphics(graphics);
        super.paint(graphics);
    }

    protected Document createDefaultModel() {
        return new InputDocument();
    }

    class InputDocument
    extends PlainDocument {
        InputDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string.indexOf(10) == -1) {
                super.insertString(n, string, attributeSet);
                return;
            }
            while (string.indexOf(10) > -1) {
                InputField.this.event.text = string.substring(0, string.indexOf(10));
                if (InputField.this.getCurrentText().length() > 0) {
                    super.insertString(n, InputField.this.event.text, attributeSet);
                    InputField.this.event.text = InputField.this.getCurrentText();
                }
                InputField.this.fireInputEvent();
                if (string.indexOf(10) == string.length()) {
                    return;
                }
                string = string.substring(string.indexOf(10) + 1, string.length());
            }
            if (string.length() > 0) {
                InputField.this.event.text = string;
                InputField.this.fireInputEvent();
            }
        }
    }
}

