/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.script;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Stack;
import rero.client.Capabilities;
import rero.gui.BuiltInLogger;
import rero.gui.GlobalCapabilities;
import rero.gui.IRCSession;
import rero.gui.SessionManager;
import rero.util.ClientUtils;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class SessionOperators
implements Loadable {
    protected IRCSession session;

    public SessionOperators(IRCSession iRCSession) {
        this.session = iRCSession;
    }

    private Capabilities getCapabilities() {
        return this.session.getCapabilities();
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        Hashtable hashtable = scriptInstance.getScriptEnvironment().getEnvironment();
        SessionUI sessionUI = new SessionUI();
        hashtable.put("&getSessionId", new getSessionId());
        hashtable.put("&getActiveSessionId", new getActiveSessionId());
        hashtable.put("&activateSession", sessionUI);
        hashtable.put("&getTotalSessions", new getTotalSessions());
        hashtable.put("&setSessionColor", sessionUI);
        hashtable.put("&getSessionColor", new getSessionColor());
        hashtable.put("&getSessionText", new getSessionText());
        hashtable.put("&setSessionText", sessionUI);
        hashtable.put("&callInSession", new callCommandInSession());
        hashtable.put("&getServerHost", new getServerName());
        hashtable.put("&getServerPort", new getServerPort());
        hashtable.put("&getServerNetwork", new getServerNetwork());
        hashtable.put("&getServerPassword", new getServerPassword());
        hashtable.put("&isServerConnected", new isServerConnected());
        hashtable.put("&isServerSecure", new isServerSecure());
        hashtable.put("&getLogFile", new getLogFile());
        hashtable.put("&logMessage", new logMessage());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    private class SessionUI
    implements Function {
        private SessionUI() {
        }

        public Scalar evaluate(final String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar = (Scalar)stack.pop();
            final int n = scalar.intValue();
            final String string2 = scalar.toString();
            ClientUtils.invokeLater(new Runnable(){

                public void run() {
                    GlobalCapabilities globalCapabilities = SessionOperators.this.getCapabilities().getGlobalCapabilities();
                    SessionManager sessionManager = globalCapabilities.getSessionManager();
                    if (string.equals("&activateSession")) {
                        sessionManager.setSelectedIndex(n);
                    }
                    if (string.equals("&setSessionColor")) {
                        sessionManager.setForegroundAt(sessionManager.getIndexFor(SessionOperators.this.getCapabilities()), Color.decode(string2));
                    }
                    if (string.equals("&setSessionText")) {
                        sessionManager.setTitleAt(sessionManager.getIndexFor(SessionOperators.this.getCapabilities()), string2);
                    }
                }
            });
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getActiveSessionId
    implements Function {
        private getActiveSessionId() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GlobalCapabilities globalCapabilities = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sessionManager = globalCapabilities.getSessionManager();
            return SleepUtils.getScalar(sessionManager.getSelectedIndex());
        }
    }

    private class getSessionId
    implements Function {
        private getSessionId() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GlobalCapabilities globalCapabilities = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sessionManager = globalCapabilities.getSessionManager();
            return SleepUtils.getScalar(sessionManager.getIndexFor(SessionOperators.this.getCapabilities()));
        }
    }

    private class getTotalSessions
    implements Function {
        private getTotalSessions() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GlobalCapabilities globalCapabilities = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sessionManager = globalCapabilities.getSessionManager();
            return SleepUtils.getScalar(sessionManager.getTabCount());
        }
    }

    private class getSessionColor
    implements Function {
        private getSessionColor() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GlobalCapabilities globalCapabilities = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sessionManager = globalCapabilities.getSessionManager();
            return SleepUtils.getScalar(sessionManager.getForegroundAt(BridgeUtilities.getInt(stack, sessionManager.getIndexFor(SessionOperators.this.getCapabilities()))).getRGB());
        }
    }

    private class callCommandInSession
    implements Function {
        private callCommandInSession() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GlobalCapabilities globalCapabilities = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sessionManager = globalCapabilities.getSessionManager();
            sessionManager.getSpecificSession(BridgeUtilities.getInt(stack, 0)).executeCommand(stack.pop().toString());
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getSessionText
    implements Function {
        private getSessionText() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GlobalCapabilities globalCapabilities = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sessionManager = globalCapabilities.getSessionManager();
            return SleepUtils.getScalar(sessionManager.getTitleAt(BridgeUtilities.getInt(stack, sessionManager.getIndexFor(SessionOperators.this.getCapabilities()))));
        }
    }

    private class isServerSecure
    implements Function {
        private isServerSecure() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            if (((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().isSecure) {
                return SleepUtils.getScalar("true");
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class isServerConnected
    implements Function {
        private isServerConnected() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            if (((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().isConnected) {
                return SleepUtils.getScalar("true");
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getServerPassword
    implements Function {
        private getServerPassword() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().password);
        }
    }

    private class getServerNetwork
    implements Function {
        private getServerNetwork() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().network);
        }
    }

    private class getServerPort
    implements Function {
        private getServerPort() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().port);
        }
    }

    private class getServerName
    implements Function {
        private getServerName() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().hostname);
        }
    }

    private class logMessage
    implements Function {
        private logMessage() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            SessionOperators.this.getCapabilities().getUserInterface().logMessage(BridgeUtilities.getString(stack, "%STATUS%"), BridgeUtilities.getString(stack, ""));
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getLogFile
    implements Function {
        private getLogFile() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(BuiltInLogger.getLogFileName(SessionOperators.this.getCapabilities().getSocketConnection().getSocketInformation(), BridgeUtilities.getString(stack, "%STATUS%")));
        }
    }
}

