/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.script;

import java.util.LinkedList;
import java.util.Stack;
import rero.config.ClientState;
import rero.gui.IRCSession;
import rero.gui.windows.ScriptedListDialog;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class UIOperators
implements Function,
Loadable {
    protected IRCSession session;

    public UIOperators(IRCSession iRCSession) {
        this.session = iRCSession;
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        String[] stringArray = new String[]{"&refreshMenubar", "&showOptionDialog", "&showHelpDialog", "&showAboutDialog", "&showSearchDialog"};
        for (int i = 0; i < stringArray.length; ++i) {
            scriptInstance.getScriptEnvironment().getEnvironment().put(stringArray[i], this);
        }
        scriptInstance.getScriptEnvironment().getEnvironment().put("&showSortedList", new openSortedWindow());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&refreshData", new refreshData());
    }

    private static LinkedList extractData(Stack stack) {
        LinkedList<String> linkedList = new LinkedList<String>();
        while (!stack.isEmpty()) {
            linkedList.add(stack.pop().toString());
        }
        return linkedList;
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&refreshMenubar")) {
            ClientState.getClientState().fireChange("loaded.scripts", null);
        } else if (string.equals("&showOptionDialog")) {
            this.session.getCapabilities().getGlobalCapabilities().showOptionDialog(BridgeUtilities.getString(stack, ""));
        } else if (string.equals("&showHelpDialog")) {
            this.session.getCapabilities().getGlobalCapabilities().showHelpDialog(BridgeUtilities.getString(stack, ""));
        } else if (string.equals("&showAboutDialog")) {
            this.session.getCapabilities().getGlobalCapabilities().showAboutDialog();
        } else if (string.equals("&showSearchDialog")) {
            this.session.getCapabilities().getUserInterface().showSearchDialog(BridgeUtilities.getString(stack, "%STATUS%"));
        }
        return SleepUtils.getEmptyScalar();
    }

    private static class refreshData
    implements Function {
        private refreshData() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            ScriptedListDialog scriptedListDialog = (ScriptedListDialog)BridgeUtilities.getObject(stack);
            scriptedListDialog.refreshData();
            return SleepUtils.getEmptyScalar();
        }
    }

    private class openSortedWindow
    implements Function {
        private openSortedWindow() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            if (stack.size() < 3) {
                return SleepUtils.getEmptyScalar();
            }
            String string2 = stack.pop().toString();
            String string3 = stack.pop().toString();
            Object e = stack.pop();
            return SleepUtils.getScalar(UIOperators.this.session.createSortedWindow(string2, string3, e, UIOperators.extractData(stack)));
        }
    }
}

