/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.script;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import rero.gui.IRCSession;
import rero.gui.SessionManager;
import rero.gui.windows.ChannelWindow;
import rero.ircfw.User;
import rero.util.ClientUtils;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import text.list.ListElement;

public class WindowOperators
implements Predicate,
Function,
Loadable {
    protected IRCSession session;

    public WindowOperators(IRCSession iRCSession) {
        this.session = iRCSession;
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        String[] stringArray = new String[]{"&setWindowPrompt", "&getWindowPrompt", "&setWindowTitle", "&getWindowTitle", "&getWindowSize", "&renameWindow", "&getSelectedText", "&cutSelectedText", "&copySelectedText", "&pasteText", "&replaceSelectedText", "&setInputText", "&getInputText", "&getSelectedUsers", "&getSelectedUser", "&getClipboardText", "&setClipboardText", "&scrollWindow", "-iswindow", "-isspecial", "&refreshWindow"};
        for (int i = 0; i < stringArray.length; ++i) {
            scriptInstance.getScriptEnvironment().getEnvironment().put(stringArray[i], this);
        }
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getCursorPosition", new getCursorPosition());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&setCursorPosition", new setCursorPosition());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&setButtonColor", new setButtonColor());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getButtonColor", new getButtonColor());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public Scalar evaluate(final String string, final ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&getSelectedText")) {
            return SleepUtils.getScalar(this.session.getActiveWindow().getInput().getSelectedText());
        }
        if (string.equals("&renameWindow") && stack.size() == 2) {
            String string2 = stack.pop().toString();
            String string3 = stack.pop().toString();
            this.session.renameWindow(string2, string3);
            return SleepUtils.getEmptyScalar();
        }
        if (string.equals("&scrollWindow") && stack.size() == 2) {
            String string4 = stack.pop().toString();
            int n = BridgeUtilities.getInt(stack, 0);
            if (this.session.getWindow(string4) != null && this.session.getWindow(string4).isLegalWindow()) {
                this.session.getWindow(string4).getDisplay().scroll(n);
            }
        } else {
            if (string.equals("&getWindowSize") && stack.size() == 1) {
                String string5 = stack.pop().toString();
                if (this.session.getWindow(string5) != null) {
                    return SleepUtils.getScalar(this.session.getWindow(string5).getWidth());
                }
                return SleepUtils.getEmptyScalar();
            }
            if (string.equals("&getWindowTitle") && stack.size() == 1) {
                String string6 = stack.pop().toString();
                if (this.session.getWindow(string6) != null) {
                    return SleepUtils.getScalar(this.session.getWindow(string6).getTitle());
                }
                return SleepUtils.getEmptyScalar();
            }
            if (string.equals("&getWindowTitle") && stack.size() == 0) {
                return SleepUtils.getScalar(SessionManager.getGlobalCapabilities().getFrame().getTitle());
            }
            if (string.equals("&getWindowPrompt") && stack.size() == 1) {
                String string7 = stack.pop().toString();
                if (this.session.getWindow(string7) != null) {
                    return SleepUtils.getScalar(this.session.getWindow(string7).getInput().getIndent());
                }
                return SleepUtils.getEmptyScalar();
            }
            if (string.equals("&getInputText") && stack.size() == 1) {
                String string8 = stack.pop().toString();
                if (this.session.getWindow(string8) != null) {
                    return SleepUtils.getScalar(this.session.getWindow(string8).getInput().getText());
                }
            } else {
                if (string.equals("&getSelectedUser") && stack.size() == 1) {
                    ListElement listElement;
                    String string9 = stack.pop().toString();
                    if (this.session.getWindow(string9) != null && (listElement = ((ChannelWindow)this.session.getWindow(string9)).getListbox().getSelectedElement()) != null) {
                        User user = (User)listElement.getSource();
                        return SleepUtils.getScalar(user.getNick());
                    }
                    return SleepUtils.getEmptyScalar();
                }
                if (string.equals("&getSelectedUsers") && stack.size() == 1) {
                    String string10 = stack.pop().toString();
                    if (this.session.getWindow(string10) != null && this.session.getWindow(string10) instanceof ChannelWindow) {
                        HashSet<String> hashSet = new HashSet<String>();
                        Iterator iterator = ((ChannelWindow)this.session.getWindow(string10)).getListbox().getSelectedElements().iterator();
                        while (iterator.hasNext()) {
                            ListElement listElement = (ListElement)iterator.next();
                            User user = (User)listElement.getSource();
                            hashSet.add(user.getNick());
                        }
                        return SleepUtils.getArrayWrapper(hashSet);
                    }
                    return SleepUtils.getEmptyScalar();
                }
                if (string.equals("&getClipboardText")) {
                    Clipboard clipboard = null;
                    if (Toolkit.getDefaultToolkit().getSystemSelection() != null) {
                        clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
                    } else if (Toolkit.getDefaultToolkit().getSystemClipboard() != null) {
                        clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    }
                    try {
                        if (clipboard != null) {
                            return SleepUtils.getScalar(clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor).toString());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return SleepUtils.getEmptyScalar();
                }
                if (string.equals("&setClipboardText")) {
                    String string11 = BridgeUtilities.getString(stack, "");
                    StringSelection stringSelection = new StringSelection(string11);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                    if (Toolkit.getDefaultToolkit().getSystemSelection() != null) {
                        Toolkit.getDefaultToolkit().getSystemSelection().setContents(stringSelection, stringSelection);
                    }
                } else {
                    final Stack<String> stack2 = new Stack<String>();
                    while (!stack.isEmpty()) {
                        stack2.push(stack.pop().toString());
                    }
                    ClientUtils.invokeLater(new Runnable(){

                        public void run() {
                            WindowOperators.this.safeEvaluate(string, scriptInstance, stack2);
                        }
                    });
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    public void safeEvaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        String string2 = "";
        String string3 = "";
        if (stack.size() == 1) {
            string2 = stack.pop().toString();
        } else if (stack.size() == 2) {
            string2 = stack.pop().toString();
            string3 = stack.pop().toString();
        }
        if (string.equals("&cutSelectedText")) {
            this.session.getActiveWindow().getInput().cut();
        } else if (string.equals("&copySelectedText")) {
            this.session.getActiveWindow().getInput().copy();
        } else if (string.equals("&pasteText")) {
            this.session.getActiveWindow().getInput().paste();
        } else if (string.equals("&replaceSelectedText")) {
            this.session.getActiveWindow().getInput().replaceSelection(string2);
        } else if (string.equals("&setWindowTitle")) {
            if (string3.length() > 0 && this.session.getWindow(string3) != null) {
                this.session.getWindow(string3).setTitle(string2);
            } else {
                SessionManager.getGlobalCapabilities().getFrame().setTitle(string2);
            }
        } else if (string.equals("&setWindowPrompt")) {
            if (this.session.getWindow(string3) != null) {
                this.session.getWindow(string3).getInput().setIndent(string2);
            }
        } else if (string.equals("&refreshWindow")) {
            if (this.session.getWindow(string2) != null) {
                this.session.getWindow(string2).touch();
            }
        } else if (string.equals("&setInputText") && this.session.getWindow(string3) != null) {
            this.session.getWindow(string3).getInput().setText(string2);
        }
    }

    public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
        if (stack.size() != 1) {
            return false;
        }
        String string2 = ((Object)((Scalar)stack.pop()).getValue()).toString();
        if (string.equals("-iswindow")) {
            return this.session.isWindow(string2);
        }
        if (string.equals("-isspecial")) {
            return !this.session.getWindow(string2).isLegalWindow();
        }
        return false;
    }

    private class setCursorPosition
    implements Function {
        private setCursorPosition() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            if (WindowOperators.this.session.getWindow(string2) != null && WindowOperators.this.session.getWindow(string2).isLegalWindow()) {
                WindowOperators.this.session.getWindow(string2).getInput().setCaretPosition(BridgeUtilities.getInt(stack, 0));
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getCursorPosition
    implements Function {
        private getCursorPosition() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            if (WindowOperators.this.session.getWindow(string2) != null && WindowOperators.this.session.getWindow(string2).isLegalWindow()) {
                return SleepUtils.getScalar(WindowOperators.this.session.getWindow(string2).getInput().getCaretPosition());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class setButtonColor
    implements Function {
        private setButtonColor() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            if (WindowOperators.this.session.getWindow(string2) != null) {
                WindowOperators.this.session.getWindow(string2).getButton().setForeground(Color.decode(stack.pop().toString()));
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getButtonColor
    implements Function {
        private getButtonColor() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            if (WindowOperators.this.session.getWindow(string2) != null) {
                return SleepUtils.getScalar(WindowOperators.this.session.getWindow(string2).getButton().getForeground().getRGB());
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

