/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.sdi;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.KeyBindings;
import rero.gui.sdi.ClientSingleWindow;
import rero.gui.toolkit.OrientedToolBar;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.StatusWindow;
import rero.gui.windows.SwitchBarOptions;
import rero.gui.windows.WindowManager;

public class ClientPanel
extends WindowManager
implements ActionListener,
ClientStateListener {
    protected StatusWindow active = null;
    protected JPanel desktop;
    protected JPanel top;
    protected JLabel button;

    public void propertyChanged(String string, String string2) {
        if (string.equals("switchbar.position")) {
            int n = ClientState.getClientState().getInteger("switchbar.position", 0);
            this.top.remove(this.button);
            if (n == 2 || n == 3) {
                this.top.add((Component)this.button, "South");
            } else {
                this.top.add((Component)this.button, "East");
            }
        } else {
            super.propertyChanged(string, string2);
        }
    }

    public void init() {
        this.switchbar = new OrientedToolBar();
        this.top = new JPanel();
        this.top.setLayout(new BorderLayout(5, 0));
        this.button = new JLabel("<html><b>X</b></html>", 0);
        this.button.setToolTipText("Close active window");
        this.button.addMouseListener(new MouseAdapter(){
            protected Color original;

            public void mousePressed(MouseEvent mouseEvent) {
                this.original = ClientPanel.this.button.getForeground();
                ClientPanel.this.button.setForeground(UIManager.getColor("TextArea.selectionBackground"));
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ClientPanel.this.processClose();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ClientPanel.this.button.setForeground(this.original);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                ClientPanel.this.button.setText("<html><b><u>X</u></b></html>");
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ClientPanel.this.button.setText("<html><b>X</b></html>");
            }
        });
        this.top.add((Component)this.switchbar, "Center");
        this.propertyChanged("switchbar.position", null);
        this.setLayout(new BorderLayout());
        this.switchOptions = new SwitchBarOptions(this, this.top);
        this.windowMap = new HashMap();
        this.windows = new LinkedList();
        this.desktop = new JPanel();
        this.desktop.setLayout(new BorderLayout());
        this.add((Component)this.desktop, "Center");
        new MantainActiveFocus(this);
        ClientState.getClientState().addClientStateListener("switchbar.position", this);
    }

    public void addWindow(StatusWindow statusWindow, boolean bl) {
        ClientSingleWindow clientSingleWindow = new ClientSingleWindow(this);
        statusWindow.init(clientSingleWindow);
        this.windowMap.put(statusWindow.getWindow(), statusWindow);
        this.windowMap.put(statusWindow.getButton(), statusWindow);
        statusWindow.getButton().addActionListener(this);
        this.addToSwitchbar(statusWindow);
        if (bl) {
            if (this.active != null) {
                this.doDeactivate(this.active);
            }
            this.desktop.add((Component)clientSingleWindow, "Center");
            this.active = statusWindow;
        }
        clientSingleWindow.processOpen();
        if (bl && !statusWindow.getButton().isSelected()) {
            statusWindow.getButton().setSelected(true);
        }
        this.revalidate();
        this.refreshFocus();
    }

    public void killWindow(ClientWindow clientWindow) {
        StatusWindow statusWindow = this.getWindowFor(clientWindow);
        if (statusWindow == null) {
            return;
        }
        ((ClientSingleWindow)statusWindow.getWindow()).processClose();
        int n = this.windows.indexOf(statusWindow);
        this.switchbar.remove(statusWindow.getButton());
        this.windowMap.remove(statusWindow.getButton());
        this.windowMap.remove(statusWindow.getWindow());
        this.windows.remove(statusWindow);
        this.desktop.remove(statusWindow);
        if (statusWindow == this.active && this.active.getName().equals("%STATUS%")) {
            this.active = null;
        } else if (statusWindow == this.active) {
            this.newActive(n, true);
            this.refreshFocus();
        }
        this.switchbar.validate();
        this.switchbar.repaint();
    }

    public void processClose() {
        if (this.active != null) {
            this.killWindow(this.active.getWindow());
        }
    }

    public StatusWindow getActiveWindow() {
        return this.active;
    }

    protected void doActivate(StatusWindow statusWindow) {
        if (this.active != null && this.active != statusWindow.getWindow()) {
            this.doDeactivate(this.active);
        }
        this.desktop.add((Component)((ClientSingleWindow)statusWindow.getWindow()), "Center");
        this.active = statusWindow;
        ((ClientSingleWindow)this.active.getWindow()).processActive();
        if (!statusWindow.getButton().isSelected()) {
            statusWindow.getButton().setSelected(true);
        }
        this.revalidate();
        this.repaint();
        this.refreshFocus();
    }

    public void refreshFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ClientPanel.this.getActiveWindow() != null && ClientPanel.this.isShowing() && ClientPanel.this.getActiveWindow().isLegalWindow() && !KeyBindings.is_dialog_active) {
                    ClientPanel.this.getActiveWindow().getInput().requestFocus();
                }
            }
        });
    }

    protected void doDeactivate(StatusWindow statusWindow) {
        this.desktop.remove((ClientSingleWindow)statusWindow.getWindow());
        ((ClientSingleWindow)statusWindow.getWindow()).processInactive();
        statusWindow.getButton().setSelected(false);
    }

    private class MantainActiveFocus
    extends ComponentAdapter {
        public MantainActiveFocus(JComponent jComponent) {
            jComponent.addComponentListener(this);
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
            ClientPanel.this.refreshFocus();
        }
    }
}

