/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.util.HashMap;
import java.util.Iterator;
import rero.client.Capabilities;
import rero.ircfw.Channel;
import rero.ircfw.User;
import text.AttributedString;
import text.AttributedText;
import text.list.ListData;
import text.list.ListElement;

public class ChannelListData
extends ListData {
    protected HashMap userInfo;
    protected Channel channel;
    protected Capabilities capabilities;
    protected HashMap event;
    protected Iterator tempIter;
    protected int iterValue;

    public void dirty() {
        this.userInfo.clear();
    }

    public void removeUser(User user) {
        this.userInfo.remove(user);
    }

    public void installCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public void updateChannel(Channel channel) {
        this.channel = channel;
        this.event = new HashMap();
        this.event.put("$channel", this.channel.getName());
        this.userInfo = new HashMap();
    }

    public ChannelListData(Channel channel) {
        this.updateChannel(channel);
    }

    public int getSize() {
        if (this.getChannel() == null) {
            return 0;
        }
        return this.getChannel().getAllUsers().size();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ListElement head() {
        if (this.getChannel() == null) {
            return null;
        }
        this.iterValue = this.getValue();
        this.tempIter = this.getChannel().getAllUsers().iterator();
        for (int i = 0; i < this.iterValue; ++i) {
            this.tempIter.next();
        }
        return this.next();
    }

    public ListElement next() {
        if (this.getChannel() != null && this.tempIter.hasNext()) {
            return this.getElementForUser((User)this.tempIter.next());
        }
        return null;
    }

    public Object getSynchronizationKeyOuter() {
        if (this.capabilities != null) {
            return this.capabilities.getDataStructure("scriptVariables");
        }
        return this.getChannel().getAllUsers();
    }

    public Object getSynchronizationKeyInner() {
        return this.getChannel().getAllUsers();
    }

    protected ListElement getElementForUser(User user) {
        UserElement userElement = (UserElement)this.userInfo.get(user);
        if (userElement == null) {
            userElement = new UserElement(user);
            this.userInfo.put(user, userElement);
        }
        userElement.touch();
        return userElement;
    }

    public ListElement getElementAt(int n) {
        if (this.getChannel() == null) {
            return null;
        }
        Iterator iterator = this.getChannel().getAllUsers().iterator();
        for (int i = 0; i < n && iterator.hasNext(); ++i) {
            iterator.next();
        }
        if (iterator.hasNext()) {
            User user = (User)iterator.next();
            return this.getElementForUser(user);
        }
        return null;
    }

    public Iterator dataIterator() {
        return new MyIterator();
    }

    private class UserElement
    extends ListElement {
        protected int oldState;
        protected User user;
        protected AttributedString idle = null;
        protected AttributedString normal = null;
        protected int oldNick;

        public UserElement(User user) {
            this.user = user;
            this.oldState = user.getModeFor(ChannelListData.this.getChannel());
            this.oldNick = user.getNick().hashCode();
            this.setSource(this.user);
        }

        public void touch() {
            if (this.oldState != this.user.getModeFor(ChannelListData.this.getChannel()) || this.oldNick != this.user.getNick().hashCode()) {
                this.idle = null;
                this.normal = null;
                this.oldNick = this.user.getNick().hashCode();
                this.oldState = this.user.getModeFor(ChannelListData.this.getChannel());
                this.setSelected(false);
            }
        }

        protected AttributedString buildString(String string) {
            if (ChannelListData.this.capabilities != null) {
                ChannelListData.this.event.put("$nick", this.user.getNick());
                AttributedString attributedString = AttributedString.CreateAttributedString(string + ChannelListData.this.capabilities.getOutputCapabilities().parseSet(ChannelListData.this.event, "NICKLIST_FORMAT"));
                attributedString.assignWidths();
                return attributedString;
            }
            return null;
        }

        protected AttributedString getData() {
            if (this.user.getIdleTime() > 300) {
                if (this.idle == null) {
                    this.idle = this.buildString("\u0016");
                }
                return this.idle;
            }
            if (this.normal == null) {
                this.normal = this.buildString("");
            }
            return this.normal;
        }

        public AttributedText getAttributedText() {
            AttributedString attributedString = this.getData();
            if (attributedString != null) {
                return this.getData().getAttributedText();
            }
            AttributedString attributedString2 = AttributedString.CreateAttributedString("");
            attributedString2.assignWidths();
            return attributedString2.getAttributedText();
        }

        public String getText() {
            return this.getData().getText();
        }
    }

    private class MyIterator
    implements Iterator {
        protected Iterator i;

        public MyIterator() {
            this.i = ChannelListData.this.getChannel().getAllUsers().iterator();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return ChannelListData.this.getElementForUser((User)this.i.next());
        }

        public void remove() {
        }
    }
}

