/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.util.HashMap;
import java.util.List;
import rero.client.output.OutputCapabilities;
import rero.dcc.DataDCC;
import rero.dcc.GenericDCC;
import rero.gui.toolkit.GeneralListModel;
import rero.gui.windows.GeneralListDialog;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.TimerListener;
import text.AttributedString;

public class DCCListDialog
extends GeneralListDialog
implements TimerListener {
    public DCCListDialog() {
        super("DCC Sessions", "dcc", new DCCListModel());
    }

    public void timerExecute() {
        this.table.repaint();
    }

    public void init() {
        ((DCCListModel)this.model).installData((DataDCC)this.capabilities.getDataStructure("dcc"), this.capabilities.getOutputCapabilities());
        this.model.fireTableDataChanged();
        this.capabilities.getTimer().addTimer(this, 1000L);
        this.capabilities.addChatListener(new DCCListener());
    }

    public String getWindowType() {
        return "DCCStats";
    }

    private static class DCCListModel
    extends GeneralListModel {
        protected DataDCC data;
        protected OutputCapabilities output;

        private DCCListModel() {
        }

        public HashMap getEventHashMap(int n) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            GenericDCC genericDCC = (GenericDCC)this.getConnections().get(n);
            hashMap.put("$this", genericDCC.getImplementation().toString());
            return hashMap;
        }

        public void installData(DataDCC dataDCC, OutputCapabilities outputCapabilities) {
            this.data = dataDCC;
            this.output = outputCapabilities;
        }

        public void sortColumn(int n, boolean bl) {
            this.fireTableDataChanged();
        }

        private List getConnections() {
            return this.data.getConnections(-1, 402);
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.getConnections().size();
        }

        public int getColumnCount() {
            return 3;
        }

        public int getColumnWidth(int n) {
            if (n == 0) {
                return 75;
            }
            if (n == 1) {
                return 100;
            }
            return 400;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Type";
                }
                case 1: {
                    return "Nickname";
                }
                case 2: {
                    return "Information";
                }
                case 3: {
                    return "File";
                }
            }
            return "Unknown";
        }

        public Object getValueAt(int n, int n2) {
            if (n >= this.getRowCount()) {
                return null;
            }
            HashMap hashMap = this.getEventHashMap(n);
            String string = "";
            switch (n2) {
                case 0: {
                    string = this.output.parseSet(hashMap, "DCC_LIST_TYPE");
                    break;
                }
                case 1: {
                    string = this.output.parseSet(hashMap, "DCC_LIST_NICK");
                    break;
                }
                case 2: {
                    string = this.output.parseSet(hashMap, "DCC_LIST_INFORMATION");
                    break;
                }
                case 3: {
                    string = this.output.parseSet(hashMap, "DCC_LIST_FILE");
                }
            }
            AttributedString attributedString = AttributedString.CreateAttributedString(string);
            attributedString.assignWidths();
            return attributedString;
        }

        public boolean isSortable(int n) {
            return false;
        }
    }

    private class DCCListener
    implements ChatListener,
    FrameworkConstants {
        private DCCListener() {
        }

        public boolean isChatEvent(String string, HashMap hashMap) {
            return string.indexOf("CHAT_") > -1 || string.indexOf("SEND_") > -1 || string.indexOf("RECEIVE_") > -1;
        }

        public int fireChatEvent(HashMap hashMap) {
            DCCListDialog.this.model.fireTableDataChanged();
            return 1;
        }
    }
}

